; * INTERRUPT-INTERCEPT *
; (c) Simon Liston 3/1/83
; from Your Computer, March 1983

;Set Interrupt Mode 2 and initialise interrupt vector table
        DI                       ; FE10 F3
        LD HL, $FCF8             ; FE11 21 F8 FC
        LD BC, $0110             ; FE14 01 10 01
Itab  : LD (HL), $F7             ; FE17 36 F7
        INC HL                   ; FE19 23
        DEC BC                   ; FE1A 0B
        LD A, B                  ; FE1B 78
        OR C                     ; FE1C B1
        JR NZ, Itab              ; FE1D 20 F8
        LD A, $FD                ; FE1F 3E FD
        LD I, A                  ; FE21 ED 47
        IM 2                     ; FE23 ED 5E
        EI                       ; FE25 FB
        RET                      ; FE26 C9

; ** Real-Time Clock **
        PUSH IX                  ; F7F7 DD E5
        PUSH AF                  ; F7F9 F5
        PUSH BC                  ; F7FA C5
        PUSH DE                  ; F7FB D5
        PUSH HL                  ; F7FC E5
        LD A, (Real)             ; F7FD 3A B2 F8
        DEC A                    ; F800 3D
        LD (Real), A             ; F801 32 B2 F8
        JP NZ, Ptime             ; F804 C2 46 F8
        LD A, $32                ; F807 3E 32
        LD (Real), A             ; F809 32 B2 F8
        LD A, (Secs)             ; F80C 3A B5 F8
        AND A                    ; F80F A7
        ADC A, $01               ; F810 CE 01
        DAA                      ; F812 27
        LD (Secs), A             ; F813 32 B5 F8
        CP $60                   ; F816 FE 60
        JP NZ, Ptime             ; F818 C2 46 F8
        XOR A                    ; F81B AF
        LD (Secs), A             ; F81C 32 B5 F8
        LD A, (Mins)             ; F81F 3A B4 F8
        AND A                    ; F822 A7
        ADC A, $01               ; F823 CE 01
        DAA                      ; F825 27
        LD (Mins), A             ; F826 32 B4 F8
        CP $60                   ; F829 FE 60
        JP NZ, Ptime             ; F82B C2 46 F8
        XOR A                    ; F82E AF
        LD (Mins), A             ; F82F 32 B4 F8
        LD A, (Hours)            ; F832 3A B3 F8
        AND A                    ; F835 A7
        ADC A, $01               ; F836 CE 01
        DAA                      ; F838 27
        LD (Hours), A            ; F839 32 B3 F8
        CP $13                   ; F83C FE 13
        JP NZ, Ptime             ; F83E C2 46 F8
        LD A, $01                ; F841 3E 01
        LD (Hours), A            ; F843 32 B3 F8

Ptime : LD IX, $4018             ; F846 DD 21 18 40
        LD A, (Hours)            ; F84A 3A B3 F8
        CALL Pdec                ; F84D CD 79 F8
        LD A, $0A                ; F850 3E 0A
        CALL Pch                 ; F852 CD 8C F8
        LD A, (Mins)             ; F855 3A B4 F8
        CALL Pdec                ; F858 CD 79 F8
        LD A, $0A                ; F85B 3E 0A
        CALL Pch                 ; F85D CD 8C F8
        LD A, (Secs)             ; F860 3A B5 F8
        CALL Pdec                ; F863 CD 79 F8
        LD HL, $5818             ; F866 21 18 58
        LD B, $08                ; F869 06 08

At    : LD (HL), $C7             ; F86B 36 C7
        INC HL                   ; F86D 23
        DJNZ At                  ; F86E 10 FB
        POP HL                   ; F870 E1
        POP DE                   ; F871 D1
        POP BC                   ; F872 C1
        POP AF                   ; F873 F1
        POP IX                   ; F874 DD E1
        JP $0038                 ; F876 C3 38 00

Pdec  : PUSH AF                  ; F879 F5
        SRL A                    ; F87A CB 3F
        SRL A                    ; F87C CB 3F
        SRL A                    ; F87E CB 3F
        SRL A                    ; F880 CB 3F
        CALL Pch                 ; F882 CD 8C F8
        POP AF                   ; F885 F1
        AND $0F                  ; F886 E6 0F
        CALL Pch                 ; F888 CD 8C F8
        RET                      ; F88B C9

Pch   : PUSH IX                  ; F88C DD E5
        LD HL, ($5C36)           ; F88E 2A 36 5C
        LD DE, $0180             ; F891 11 80 01
        ADD HL, DE               ; F894 19
        EX DE, HL                ; F895 EB
        LD L, A                  ; F896 6F
        LD H, $00                ; F897 26 00
        ADD HL, HL               ; F899 29
        ADD HL, HL               ; F89A 29
        ADD HL, HL               ; F89B 29
        ADD HL, DE               ; F89C 19
        LD DE, $0100             ; F89D 11 00 01
        LD B, $08                ; F8A0 06 08

Wr    : LD A, (HL)               ; F8A2 7E
        XOR $FF                  ; F8A3 EE FF
        LD (IX+$00), A           ; F8A5 DD 77 00
        INC HL                   ; F8A8 23
        ADD IX, DE               ; F8A9 DD 19
        DJNZ Wr                  ; F8AB 10 F5
        POP IX                   ; F8AD DD E1
        INC IX                   ; F8AF DD 23
        RET                      ; F8B1 C9

Real  : DEFB 50
Hours : DEFW 63667
Mins  : DEFW 63668
Secs  : DEFW 63669
