#!/bin/csh
setenv PILROOT /usr/local/pilot/bin
setenv GIFPATH  /usr/home/gsd/dilbertgifs
setenv FILENAME  `ls -t $GIFPATH/*.gif|head -1`
setenv UFFILENAME `ls -t $GIFPATH/userfriendly/*.gif|head -1`
setenv FILEDATE `date +%Y%m%d`

/usr/local/bin/convert $FILENAME $FILENAME.PBM
/usr/local/bin/convert $UFFILENAME $UFFILENAME.PBM

/usr/local/bin/pbmtoimgv -t $FILEDATE\dilbert $FILENAME.PBM $FILENAME.PBM.pdb
/usr/local/bin/pbmtoimgv -t $FILEDATE\ufie $UFFILENAME.PBM $UFFILENAME.PBM.pdb

$PILROOT/ppplinkdown
$PILROOT/pilot-xfer -i $FILENAME.PBM.pdb $UFFILENAME.PBM.pdb
$PILROOT/ppplinkup

rm $FILENAME.PBM $UFFILENAME.PBM
rm $FILENAME.PBM.pdb $UFFILENAME.PBM.pdb
