
;     TXT2Emu - import a BASIC text file into an emulator

;     REM If "Length?">0 then starts at address 's'
;     REM If "Length?"=0 then starts at address 'FN p(23670)'
;     REM After a syntax error, FN p(23670) holds address of next line
;         (ie. the line following the error line)
;         After correcting error in editor, resume with "Length?"=0
;         *DO NOT RELOAD THE TEXT FILE*

;     REM *IMPORTANT*
;         A syntax error will display in the lower screen. Correct
;         the error in the lower screen before switching back to the
;         upper screen to resume.

;     REM TXT2Emu BASIC loader
;     REM this line must be the first line in the PROG area, hence line 0
;   0 CLEAR VAL "65535-32": INPUT "Length? (0 Resumes) ";l:
;     LET s=VAL "65535-32-128-l": LET s=s-(s-FN p(23670) AND NOT l):
;     IF FN p(23653)+40<s THEN
;     INPUT (("Load at "+ STR$ s+" then ") AND l);"Press ENTER "; LINE a$:
;     LOAD "TXT2Emu" CODE VAL "16384":
;     RANDOMIZE s: DEF FN p(a)=PEEK a+256*PEEK(a+SGN PI):
;     RANDOMIZE USR VAL "16384"

        ;RANDOMIZE USR VAL "16384" must be last statement on line 0
        ;to delete line 0: POKE FN p(23635)+1,1 [ENTER] 1 [ENTER]
        ;keywords should be in all CAPITAL letters
        ;variable names may use both CAPITAL and small letters
        ;spaces not inside quotes or after a REM will be discarded
        ;a BASIC line may be split across multiple text lines
        ;a BASIC line starts with zero or more spaces followed by a digit 0-9
        ;a text line with no line number will be appended to the previous line
        ;(or ignored if it's the first line)
        ;BASIC lines may be inserted/changed/deleted
        ;line numbers do not need to be in ascending order
        ;(they will be inserted in their correct numerical sequence regardless)

        ;these special encodings can be used in the text file:
        ;{00}-{FF} .for hex byte values $00-$FF
        ;{80}-{87} .for unshifted block graphics
        ;{88}-{8F} .for   shifted block graphics
        ; {A}-{U} ..for UDGs A-U

        ;see lines 203,205 for "truncate REM" changes
        ;corrections for 128 error handling marked '**'

        org  16384
        ;128k system variables
TARGET: equ  23384           ;$5B58
RAMRST: equ  23389
OLDSP128:  equ  23425        ;$5B81 (OLDSP +128k/+2)
OLDSP2A3:  equ  23402        ;$5B6A (OLDSP +2A/+3/+3e)
TSTACK: equ  23551           ;$5BFF
        ;standard system variables
ERR_SP: equ  23613
E_LINE: equ  23641
K_CUR:  equ  23643
CH_ADD: equ  23645
STKEND: equ  23653           ;$5C65
TEXTAT: equ  23670           ;$5C76 (SEED) start of text file
RAMTOP: equ  23730

KEYSIZE:equ  9               ;longest keyword is RANDOMIZE
TEXTEND:equ  65535-32-128-1  ;allow space for m/c stack below RAMTOP at 65535

TXT2EMU:jp   EDIT_L
        defs 8
        jp   ERROR_C         ;"C Nonsense in BASIC" redirection at $400B

EDIT_L: xor  a               ;select channel 'K'
        call $1601           ;CHAN_OPEN
        ld   hl,TEXTEND
        inc  hl
        ld   (hl),$0D        ;ensure last line ends with Enter
        ld   a,(iy+48)       ;A =(FLAGS2)
        and  %00010000       ;reset all except "channel K" bit
        ld   (iy+48),a

        bit  4,(iy+$01)      ;determine Spectrum model
        jr   z,COPYMA        ;48k
        ld   a,($0013)
        inc  a               ;A =168 if +2A/+3/+3e else 0
        ld   c,a
        ld   a,($1540)       ;A =83 if Sinclair else 65 if Amstrad
        add  a,c             ;A =83 +128k; =65 +2; =233 +2A/+3/+3e
        cp   233
        jr   nz,STARTL       ;+128k/+2
        set  7,(iy+48)       ;2A/+3/+3e

STARTL: ld   hl,23384
        ld   de,SYSVARS
        ld   bc,SIZVARS128
        bit  7,(iy+48)
        jr   z,COPYSYS
        ld   bc,SIZVARS2A3
COPYSYS:ldir                 ;save 128k system variables
        ld   ix,(ERR_SP)   ;**
        ld   (MERRSP),ix   ;**save location of error return
        ld   l,(ix+00)     ;**
        ld   h,(ix+01)     ;**
        ld   (MERRAD),hl   ;**save the error return
        ld   (ix+00),$0B   ;**
        ld   (ix+01),$40   ;**change error return to $400B for syntax error
        jr   EDITALL

COPYMA: ld   hl,$155d        ;MAIN_ADD needs to be copied from ROM
        ld   de,MAINADD      ;so that a RET can be put at the end
        ld   bc,79
        ldir                 ;copy MAIN_ADD code from ROM
        ld   hl,(ERR_SP)
        ld   (MERRSP),hl     ;save location of error return

EDITALL:ld   bc,(CH_ADD)
        ld   (SAVECHA),bc    ;save (CH_ADD)
        exx
        ld   (SAVEHL1),hl    ;save HL'
        ld   hl,(TEXTAT)
LOOP_0: ld   a,(hl)          ;loop to find start of printable text
        inc  hl
        cp   "!"
        jr   c,LOOP_0
        dec  hl
        dec  hl              ;HL=text start address - 1
        ld   ix,23681        ;(23681)=current keyword code

NEXT_L: push hl           ;1>
        bit  4,(iy+$01)
        jr   z,NOCOPY        ;48k

        inc  hl              ;128k save current line
        ld   d,h             ;to copy to Screen Line Edit Buffer
        ld   e,l             ;in case of syntax error
        ld   bc,0
        ld   a,$0D
        cpir                 ;search for end of line
        and  a
        sbc  hl,de
        ld   b,h
        ld   c,l
        ex   de,hl
        ld   de,$4800
        ldir                 ;copy line to temporary screen buffer

NOCOPY: call $16b0           ;SET_MIN (reset editing area, etc.)
        pop  hl           ;1<;HL=text input pointer
        ld   d,h
        ld   e,l             ;DE=tokenising pointer
        ld   (TEXTAT),de
NEXT_C: inc  de
NOSPACE:inc  hl
        ld   a,(hl)
        ld   (de),a
        cp   $09
        jr   z,NOTXXX        ;tabs will be discarded later
        cp   " "
        jr   c,POL           ;treat any non-printable char as "soft-EOL"
        cp   "{"
        jr   nz,NOTXXX

        push hl              ;check for {XX} or {X} encodings
        inc  hl
        ld   b,(hl)
        inc  hl
        ld   c,(hl)
        inc  hl
        ld   a,"}"
        cp   (hl)
        jr   nz,NOTXX

        ;handle {XX} = $00->$FF
        ld   a,b
        cp   "A"
        jr   c,BYTEHI
        sub  7
BYTEHI: sub  48
        sla  a
        sla  a
        sla  a
        sla  a
        ld   b,a
        ld   a,c
        cp   "A"
        jr   c,BYTELO
        sub  7
BYTELO: sub  48
        add  a,b
        jr   FINXXX

NOTXX:  cp   c
        jr   nz,NOTX
        ;handle {X} = UDGs A->U
        dec  hl
        ld   a,b
        add  a,$4F

FINXXX  pop  bc              ;discard old HL
        push hl
        ld   (hl),a
        ld   (de),a
NOTX:   pop  hl
NOTXXX: bit  5,(iy+48)       ;after REM?
       ;dec  de              ;enable for no copy
        jr   nz,NEXT_C       ;plain/no copy if after REM
       ;inc  de              ;enable for no copy
        cp   '"'
        jr   nz,NOQUOTE
        ld   a,(iy+48)       ;(FLAGS2)
        xor  %00000100       ;toggle "inside quotes" flag
        ld   (iy+48),a
        jr   NEXT_C
NOQUOTE:bit  2,(iy+48)       ;inside quotes?
        jr   nz,NEXT_C       ;plain copy if inside quotes
        cp   " "
        jr   z,NOSPACE       ;otherwise ignore spaces
        cp   $09
        jr   z,NOSPACE       ;& tabs
        cp   "<"
        jr   c,NEXT_C        ;if < "<"
        cp   "["
        jr   nc,NEXT_C       ;if > "Z"

        call TOKENIT         ;keywords may be <=,>=,<> or start A-Z
        jr   NEXT_C

POL:    inc  hl              ;check for next printable non-space
        ld   a,(hl)          ;character after EOL
        cp   "!"
        jr   c,POL
        push hl
        exx
        pop  hl
        ld   de,TEXTEND
        sbc  hl,de
        exx
        dec  hl
        jr   nc,EOL          ;jump if at end of last line
        dec  de
        cp   "0"             ;check if next line starts with a number
        jp   c,NEXT_C        ;if not, append to current line
        cp   ":"
        jp   nc,NEXT_C
        inc  de

EOL:    push hl           ;1>;save text input pointer
        and  a
        ld   bc,(TEXTAT)
        ld   (TEXTAT),hl     ;save Resume point (start of next line)
        ld   h,b
        ld   l,c
        inc  hl
        ex   de,hl           ;HL=tokenising pointer, DE=tokenised line start address
        sbc  hl,de
        jp   z,NO_OP         ;No-Op if no text

        ld   b,h
        ld   c,l             ;BC=tokenised line length
        ld   (SAVEBC1),bc
        ex   de,hl
        ld   de,(E_LINE)
        push de           ;2>
        push bc           ;3>
        push hl           ;4>
        ex   de,hl
        call $1655           ;MAKE_ROOM (in editing area)
        pop  hl           ;4<
        pop  bc           ;3<
        pop  de           ;2<
        ldir                 ;copy line into editing area
        push de           ;2>
        CALL $19FB           ;E_LINE_NO check line number
        pop  de           ;2<
        LD   A,B             ;Is there a valid line number?
        OR   C
        jp   z,NO_OP         ;No-Op if no line number

        bit  4,(iy+01)
        jr   nz,ENDLINE      ;128k

        ld   (K_CUR),de      ;48k
        ld   hl,(CH_ADD)
        ld   de,(E_LINE)
        sbc  hl,de           ;HL=length of line number
        push hl
        push bc
        ;If the If.1 Shadow ROM is paged by an If.1/Microdrive command
        ;it annihilates the stack, so use a temporary stack for LINE_SCAN
        di
        ld   (MSTACK),sp     ;save the stack pointer
        ld   hl,(MSTACK)     ;put the top of the temp.stack
        ld   bc,LINERET      ;just below the current stack
        dec  hl
        ld   (hl),b          ;store the temp.error return
        dec  hl              ;at the top of the temp.stack
        ld   (hl),c
        ld   (ERR_SP),hl     ;and change (ERR_SP) to point to it
        ld   sp,hl
        CALL $1B17           ;LINE_SCAN check syntax
LINERET:
        ld   hl,(MERRSP)
        ld   (ERR_SP),hl     ;restore the original (ERR_SP)
        ld   sp,(MSTACK)     ;and stack pointer
        ei
        bit  7,(iy+00)       ;check ERR_NR
        jr   nz,LINEOK
        ld   ix,(ERR_SP)
        ld   (ix+00),$b7     ;Make error return into MAIN_2:$12b7
        ld   (ix+01),$12     ;after a syntax error.
        jp   $12b7

LINEOK: ;the system variables area will expand the first time that
        ;a Shadow ROM command is parsed, so CH_ADD must be recalculated
        pop  bc              ;BC=line number
        pop  hl              ;HL=length of line number
        ld   de,(E_LINE)
        add  hl,de
        ld   (CH_ADD),hl     ;should point to 1st character after line number
        call MAINADD         ;enter new BASIC line
        jr   NO_OP

ENDLINE:ld   hl,$5000        ;128k - put temporary m/c stack low
        ld   bc,160
        add  hl,bc
        ld   bc,(SAVEBC1)    ;BC=tokenised line length
        add  hl,bc           ;HL=temporary m/c stack location
        ld   a,%00000000     ;ROM0,RAM0 (+128k/+2), ROM1,RAM0(+2A/+3)
        bit  7,(iy+48)
        jr   nz,EL_2A3

        call SWIR128
        CALL $026B           ;enter line, in ROM0 (Editor ROM)
        bit  7,(iy+00)     ;**
        jp   z,ERROR_C     ;**
        ld   hl,(OLDSP128)
        ld   a,%00010000     ;ROM1,RAM0
        call SWIR128
        jr   NO_OP

EL_2A3: call SWIR2A3
        CALL $24F0           ;enter line, in ROM1 (Syntax ROM)
        bit  7,(iy+00)     ;**
        jp   z,ERROR_C     ;**
        ld   hl,(OLDSP2A3)
        ld   a,%00000100     ;ROM3,RAM0
        call SWIR2A3

NO_OP:  pop  de           ;1<;DE=text input pointer
        ld   hl,TEXTEND
        and  a
        sbc  hl,de
        ex   de,hl           ;HL=text input pointer
        res  2,(iy+48)       ;reset "inside quotes"
        res  5,(iy+48)       ;reset "after REM"
        jr   z,FINISH
        jp   nc,NEXT_L

FINISH: ld   bc,(SAVECHA)
        ld   (CH_ADD),bc     ;restore (CH_ADD)
        ld   hl,(SAVEHL1)
        exx                  ;restore HL'
        res  2,(iy+48)
        bit  4,(iy+01)
        jr   nz,RESTRST      ;128k

        ld   ix,(ERR_SP)     ;48k
        ld   (ix+00),$03     ;Restore MAIN_4:$1303 error return.
        ld   (ix+01),$13
        ret

RESTRST:ld   hl,SYSVARS      ;restore 128k system variables
        ld   de,23384
        ld   bc,SIZVARS128
        bit  7,(iy+48)
        jr   z,RESTALL
        ld   bc,SIZVARS2A3
RESTALL:ldir
        ld   hl,(MERRAD)   ;**
        ld   ix,(MERRSP)   ;**
        ld   (ERR_SP),ix   ;**
        ld   (ix+00),l     ;**
        ld   (ix+01),h     ;**restore the error return
        ret

SAVEBC1:defw 0000
SAVEHL1:defw 0000
SAVEHL2:defw 0000
SAVECHA:defw 0000
MSTACK: defw 0000

MERRSP: defw 0000            ;**location of error return (ie. (ERR_SP))
MERRAD: defw 0000            ;**value for error return (ie. ((ERR_SP)))

SIZVARS128:equ  53
SIZVARS2A3:equ  22
SYSVARS:defs SIZVARS128

SWIR128:di                   ;+128k/+2
        ld   (OLDSP128),sp
        ld   sp,hl           ;switch to temporary m/c stack
        ld   (23388),a
        ld   bc,$7ffd
        out  (c),a           ;change memory configuration
        cp   %00000111       ;ROM0,RAM7
        jr   z,STLO128
        ld   hl,(OLDSP128)
        ld   (OLDSP128),sp
        ld   sp,hl           ;restore current SP
        ei
        reti
STLO128:ld   bc,(TARGET)     ;use low stack if RAMpage 7 loaded
        push bc              ;as high stack has been paged out
        ld   bc,(RAMTOP)
        inc  bc
        ld   (OLDSP128),bc
        ei
        reti

SWIE2A3:di                   ;+2A/+3
        ld   (23388),a       ;BANKM
        ld   bc,$7ffd
        jr   SWIT2A3
SWIR2A3:di
        ld   (23399),a       ;BANK678
        ld   bc,$1ffd
SWIT2A3:ld   (OLDSP2A3),sp
        ld   sp,hl           ;switch to temporary m/c stack
        out  (c),a           ;change memory configuration
        cp   %00000111       ;ROM0,RAM7
        jr   z,STLO2A3
        ld   hl,(OLDSP2A3)
        ld   (OLDSP2A3),sp
        ld   sp,hl           ;restore current SP
        ei
        reti
STLO2A3:ld   bc,(TARGET)     ;use low stack if RAMpage 7 loaded
        push bc              ;as high stack has been paged out
        ld   bc,(RAMTOP)
        inc  bc
        ld   (OLDSP2A3),bc
        ei
        reti

TOKENIT:inc  hl              ;deal with <=,>=,<> tokens
        cp   "<"             ;comparing (HL-1)
        ld   c,199           ;C =code for "<="
        jr   z,LTGT
        inc  c               ;C =code for ">="
        cp   ">"
        jr   nz,NOLTGT
LTGT:   ld   a,(hl)
        cp   "="
        jr   nz,NOTEQL
TOKRET: ld   a,c
        ld   (de),a
        ret
NOTEQL: inc  c
        inc  c               ;C =code for "<>"
        cp   ">"
        jr   z,TOKRET

NOLTGT: dec  hl              ;deal with tokens starting A-Z
        cp   "A"
        ret  c
        set  6,(iy+48)       ;set "first pass"
        push hl           ;1>
        exx
        pop  hl           ;1<
RENTRY: push hl           ;1>;HL=start of string being checked
        ld   c,1             ;C =string length (already got 1st char)
KEYCHAR:inc  hl
        ld   a,(hl)
        bit  6,(iy+48)       ;check "first pass"
        jr   z,KEY2ND        ;tokens may contain " ",$,#,A-Z
        cp   " "
        jr   z,KEYINC
        cp   "$"
        jr   z,KEYINC
        cp   "#"
        jr   z,KEYINC
KEY2ND: cp   "A"
        jr   c,KEYDONE
        cp   "["
        jr   nc,KEYDONE
KEYINC: inc  c               ;character is amongst " ",$,#,A-Z
        jr   KEYCHAR

KEYDONE:dec  hl
        ld   a,(hl)
        cp   " "
        jr   nz,NOTASP
        dec  c
        jr   KEYDONE         ;ignore trailing spaces
NOTASP: ld   a,c
        pop  hl           ;1<;HL=start of string being checked
        ld   (SAVEHL2),hl
        ; If returning from a syntax error in 128 mode
        ; IX will have been changed, so restore it here.
        ld   ix,23681        ;(23681)=current keyword code
        jr   KEYFIND

NOTAKEY:bit  6,(iy+48)       ;check "first pass"
        res  6,(iy+48)
        ld   hl,(SAVEHL2)    ;HL=start of string being checked
        jr   nz,RENTRY       ;restart search, but restricted to 1st word
        ld   a,c
        exx                  ;plain copy if no keyword match
        ld   hl,(SAVEHL2)    ;HL=start of string being checked
        ld   b,0
        ld   c,a
        ldir
        dec  hl
        dec  de
        ret

KEYS128:defm "SPECTRU","M"+$80,"PLA","Y"+$80     ;extra 128k keywords

KEYFIND:ld   hl,KEYS128-1    ;HL=128 extra keyword table address - 1
        ld   (ix+00),162     ;D =1st keyword code (SPECTRUM) - 1
        ld   c,a             ;C =length of text string to be compared
KRESET: ld   b,0             ;B =length checked
        inc  (ix+00)         ;D =current keyword code
        jr   z,NOTAKEY
        ld   de,(SAVEHL2)    ;DE=start of string being checked
        ld   a,165
        cp   (ix+00)
        jr   nz,KCOUNT
        ld   hl,$0095        ;HL=keyword table address (skip $BF at $0095)
KCOUNT: inc  hl
        ld   a,(de)
        inc  de
        xor  (hl)
        and  %01111111       ;reset end-of-token-string hi-bit (if any)
        jr   nz,CHARNO       ;jump if mis-match
        inc  b               ;B =length checked OK
        ld   a,b
        cp   c               ;end of string?
        jr   z,EOS           ;jump if end of string
        bit  7,(hl)          ;end of keyword?
        jr   z,KCOUNT        ;loop if not end of string or keyword
        ld   a,(de)          ;end of keyword, check next character
        cp   " "
        jr   z,ISPACE

CHARNO: bit  7,(hl)          ;loop to end of keyword
        jr   nz,KRESET       ;then check next keyword
NOTEOK: inc  hl
        jr   CHARNO
EOS:    bit  7,(hl)
        jr   z,NOTEOK        ;jump if not end of keyword

KEYOK:  ld   a,(de)
        cp   " "
        jr   z,ISPACE        ;discard any trailing space
        dec  de
ISPACE: push de
        exx
        pop  hl              ;HL=end of string being checked
        ld   a,(ix+00)
        ld   (de),a
        cp   234             ;REM
        ret  nz
        set  5,(iy+48)       ;set "after REM" flag
        ret

MAINADD:defs 79              ;space for copy of MAIN_ADD
        ret                  ;(copy not needed for 128k, ends with RET anyway)

        ;handle "Nonsense in BASIC" (syntax error) 128k
IEC00:  defb %10000100,0,0,%10000100,0,0,0,0

ERROR_C:call RESTRST         ;restore RAMRST, etc.
        bit  7,(iy+48)
        jr   nz,ERR2A3

        ld   hl,ERET128      ;+128k/+2
        ld   (TARGET),hl     ;save return as RAM0 hi-stack gets paged out
        ld   hl,TSTACK
        ld   a,%00000111     ;ROM0,RAM7
        call SWIR128
ERET128:LD   IX,$FD6C        ;IX=cursor settings address in workspace
        jr   ERRINIT

ERR2A3: ld   hl,TSTACK       ;+2A/+3
        ld   a,%00000000     ;ROM1,RAM0
        call SWIR2A3
        ld   hl,ERET2A3
        ld   (TARGET),hl     ;save return as RAM0 hi-stack gets paged out
        ld   hl,TSTACK
        ld   a,%00000111     ;ROM0,RAM7
        call SWIE2A3
ERET2A3:LD   IX,$FD98        ;IX=cursor settings address in workspace

        ;initialise editor workspace
ERRINIT:ld   hl,IEC00
        ld   de,$EC00
        ld   bc,8
        ldir
        xor  a
        ld   hl,$EC16
        ld   de,$EC17
        ld   bc,735-1
        ld   (hl),a
        ldir                 ;reset Screen Line Edit Buffer
        ld   hl,$F6F5
        ld   de,$F6F6
        ld   bc,738-1
        ld   (hl),a
        ldir                 ;reset Below-Screen Line Edit Buffer (& settings)
       ;CALL $30D6           ;Below-Screen Line Edit Buffer settings
        ld   hl,$F9DB
        ld   de,$F9DC
        ld   bc,703+9-1
        ld   (hl),a
        ldir                 ;reset Above-Screen Line Edit Buffer (& settings)
       ;CALL $3222           ;Above-Screen Line Edit Buffer settings
        bit  7,(iy+48)
        jr   nz,LOWR2A3

        call $26a4           ;switch to lower screen, avoiding CLS
        ld   a,$0D
        call $2669           ;open up a blank line
        jr   SYNLOOP-3

LOWR2A3:call $0751           ;switch to lower screen, avoiding CLS
        ld   a,$0D
        call $0716           ;open up a blank line

        ;enter bad line into workspace
        ld   hl,$4800
SYNLOOP:ld   a,(hl)
        inc  hl
        ld   (SAVEHL2),hl
        ld   bc,PROCRET
        bit  7,(iy+48)
        jr   nz,SYNL2A3

        cp   $0D             ;+128k/+2
        jr   nz,PRGO128      ;end of line?
        ld   bc,$2667        ;return to Editor after Enter
PRGO128:push bc
        jp   $2669           ;process character code

SYNL2A3:cp   $0D             ;+2A/+3
        jr   nz,PRGO2A3      ;end of line?
        ld   bc,$0714        ;return to Editor after Enter
PRGO2A3:push bc
        jp   $0716           ;process character code

PROCRET:ld   hl,(SAVEHL2)
        jr   SYNLOOP

;************