
#{ article.sh }			Last update: 26.Mar.2001 11:22 AM
#  Author:   Jim Grimwood
#  TABS @ 4

BASE=`expr "$1" : '\(yr..\)_.*'`
test ! "$BASE"  &&  { echo "Invalid file name"; exit 1; }
FILE=$1

cd tmp
case `uname` in
hatfield	)
	DRIVE=d:; SCRIPTS=scripts ;;
*	)
	DRIVE=c:; SCRIPTS=bin ;;
esac

echo "Copy from DOS? \c"; read YN
if test "$YN" = y
then
	doscp -m $DRIVE/spectrum/yrua/$BASE/$FILE.txt .
	test $? -ne 0  &&  { echo "File $DRIVE/spectrum/yrua/$BASE/$FILE.txt not found"; exit 2; }
fi

echo "Run? \c"; read YN
test "$YN" != y  &&  exit

awk	'

BEGIN	{
	LENFILE = FILE ".ddl"	# Length of each line
	FONFILE = FILE ".ddf"	# Font for each line (0/1/2/3/...127)
	DATFILE = FILE ".ddd"	# Text for each line
	BRKFILE = FILE ".ddb"	# Section break points
	HI["0"]=0  ; LO["0"]=0
	HI["1"]=16 ; LO["1"]=1
	HI["2"]=32 ; LO["2"]=2
	HI["3"]=48 ; LO["3"]=3
	HI["4"]=64 ; LO["4"]=4
	HI["5"]=80 ; LO["5"]=5
	HI["6"]=96 ; LO["6"]=6
	HI["7"]=112; LO["7"]=7
	HI["8"]=128; LO["8"]=8
	HI["9"]=144; LO["9"]=9
	HI["a"]=160; LO["a"]=10
	HI["b"]=176; LO["b"]=11
	HI["c"]=192; LO["c"]=12
	HI["d"]=208; LO["d"]=13
	HI["e"]=224; LO["e"]=14
	HI["f"]=240; LO["f"]=15

	# end of data markers; set to 255 if the file needs 255s reset to zero
	LEND = 128; FEND = 128; DEND = 128; BEND = 128
}

$0 ~ /^!\$/	{
	# !$ = marker for end of article text
	exit
}

$0 ~ /^!B/	{
	# !B = section break marker
	BREAK = ENTRIES + 1
	HB = int( BREAK/256 )
	LB = BREAK - HB*256
	if( HB == 0 )
	{
		HB = 255; BEND = 255
	}
	if( LB == 0 )
	{
		LB = 255; BEND = 255
	}
	printf( "%c%c", LB,HB ) > BRKFILE
	next
}

$0 ~ /^![0123S]/	{
	# !{0123} = marker for change of font
	# 0 = standard 32-pitch
	# 1 = PrintPR  48-pitch
	# 2 = Print64  64-pitch
	# 3 = Print42  42-pitch
	if( $0 ~ /^!0/ )	FNT = 0
	if( $0 ~ /^!1/ )	FNT = 1
	if( $0 ~ /^!2/ )	FNT = 2
	if( $0 ~ /^!3/ )	FNT = 3

	if( $0 ~ /^!S/  &&  length($0) > 2 )
	{
		# !S = marker for SCREEN$ file name
		SFNAME = substr($0,3,10)
		printf( "%c", 127 ) > FONFILE
		printf( "%c", length(SFNAME) ) > LENFILE
		printf( "%s", SFNAME ) > DATFILE
		ENTRIES++
	}

	GPC = 0; next
}

{
	CTLS = 0
	if( FNT == 0 && $0 ~ /\\/  ||  $0 ~ /^!P/ )
		SETC = 1
	else
		SETC = 0

	# check for local print controls in standard 32-pitch lines,
	# or global print controls
	# !P = marker for global print controls
	# if SETC not set, just map \ specials to ASCII equivalent
	# - don`t count as print controls
	if( $0 ~ /\\/ )
	{
		LINE = ""
		for( CH=1; CH<=length($0); CH++ )
		{
			if( substr($0,CH,1) == "\\" )
			{
				CTLV = 92	# ASCII "\"
				if( substr($0,CH+1,1) == "D" )
				{
					# decimal
					CTLV = substr($0,CH+2,3)+0
					CH += 4; CTLS += SETC
				}
				if( substr($0,CH+1,1) == "H" )
				{
					# hexadecimal
					CTLV = HI[substr($0,CH+2,1)] + LO[substr($0,CH+3,1)]
					CH += 3; CTLS += SETC
				}
				if( CTLV == 0 )
				{
					# printf won`t print a null 00h character
					CTLV = 255; DEND = 255
				}
				LINE = sprintf( "%s%c", LINE,CTLV )
			}
			else
			{
				# regular characters in a GPC line are discarded
				if( $0 !~ /^!P/ )
					LINE = sprintf( "%s%s", LINE,substr($0,CH,1) )
			}
		}

		if( $0 ~ /^!P/ )
		{
			if( LINE > "" )
			{
				# save the global print controls; truncate to 10 bytes
				GPC = 1; GPCS = sprintf( "%-.10s", LINE )
				# set GPCS to a multiple of 2 bytes
				for( GPB=1; GPB<=int(length(GPCS)/2)*2; GPB+=2 )
					;	# No-Op
				GPCS = substr(GPCS,1,GPB-1)
				# pad to 10 with "OVER 1" if necessary
				while( length(GPCS) < 10 )
					GPCS = sprintf( "%s%c%c", GPCS,21,1 )
			}
			next
		}
		else
			$0 = LINE
	}

	LEN = length($0)
	if( FNT+GPC*128 == 0 )
	{
		printf( "%c", 255 ) > FONFILE
		FEND = 255
	}
	else
		printf( "%c", FNT+GPC*128 ) > FONFILE

	# Long lines will be truncated by the substr below
	if( FNT == 0  &&  LEN-CTLS > 32 )	LEN = 32+CTLS
	if( FNT == 1  &&  LEN > 48 )	LEN = 48
	if( FNT == 2  &&  LEN > 64 )	LEN = 64
	if( FNT == 3  &&  LEN > 42 )	LEN = 42

	LEN += GPC*10
	if( LEN == 0 )
	{
		# printf won`t print a null 00h character
		printf( "%c", 255 ) > LENFILE
		LEND = 255
	}
	else
	{
		printf( "%c", LEN ) > LENFILE
		if( GPC == 1 )
		{
			# if global print controls are active, prefix them to
			# each affected line
			printf( "%s", GPCS ) > DATFILE
		}
		printf( "%s", substr($0,1,LEN-GPC*10) ) > DATFILE
	}
	ENTRIES++
}

END	{
	# Append End-of-Data markers
	printf( "%c", LEND ) > LENFILE
	printf( "%c", FEND ) > FONFILE
	printf( "%c", DEND ) > DATFILE
	printf( "%c", BEND ) > BRKFILE
}

'	FILE=$FILE $FILE.txt

ls -l $FILE.dd[bdfl]

echo "Copying $FILE.txt ..."
doscp -m $FILE.txt $DRIVE/spectrum/yrua/$BASE
echo "Copying $FILE.dd[bdfl] to $FILE.dd0 ..."
cat $FILE.dd[bdfl] >$FILE.dd0
doscp -r $FILE.dd0 $DRIVE/spectrum/yrua/$BASE

