
#{ taplist.awk }			Last update: 28.May.2001  7:55 PM
#  Author:   Jim Grimwood
#  TABS @ 4

BEGIN	{
	LB = 0		# INPUT  BYTE POSITION WITHIN COMMAND LINE
	LP = 0		# OUTPUT CHAR POSITION WITHIN COMMAND LINE
	SPACES = "                "		# 16 SPACES
	TOKEN["a5"]="RND"
	TOKEN["a6"]="INKEY$"
	TOKEN["a7"]="PI"
	TOKEN["a8"]="FN "
	TOKEN["a9"]="POINT "
	TOKEN["aa"]="SCREEN$ "
	TOKEN["ab"]="ATTR "
	TOKEN["ac"]="AT "
	TOKEN["ad"]="TAB "
	TOKEN["ae"]="VAL$ "
	TOKEN["af"]="CODE "
	TOKEN["b0"]="VAL "
	TOKEN["b1"]="LEN "
	TOKEN["b2"]="SIN "
	TOKEN["b3"]="COS "
	TOKEN["b4"]="TAN "
	TOKEN["b5"]="ASN "
	TOKEN["b6"]="ACS "
	TOKEN["b7"]="ATN "
	TOKEN["b8"]="LN "
	TOKEN["b9"]="EXP "
	TOKEN["ba"]="INT "
	TOKEN["bb"]="SQR "
	TOKEN["bc"]="SGN "
	TOKEN["bd"]="ABS "
	TOKEN["be"]="PEEK "
	TOKEN["bf"]="IN "
	TOKEN["c0"]="USR "
	TOKEN["c1"]="STR$ "
	TOKEN["c2"]="CHR$ "
	TOKEN["c3"]=" NOT "
	TOKEN["c4"]="BIN "
	TOKEN["c5"]=" OR "
	TOKEN["c6"]=" AND "
	TOKEN["c7"]="<="
	TOKEN["c8"]=">="
	TOKEN["c9"]="<>"
	TOKEN["ca"]="LINE "
	TOKEN["cb"]=" THEN "
	TOKEN["cc"]=" TO "
	TOKEN["cd"]=" STEP "
	TOKEN["ce"]="DEF FN "
	TOKEN["cf"]="CAT "
	TOKEN["d0"]="FORMAT "
	TOKEN["d1"]="MOVE "
	TOKEN["d2"]="ERASE "
	TOKEN["d3"]="OPEN #"
	TOKEN["d4"]="CLOSE #"
	TOKEN["d5"]="MERGE "
	TOKEN["d6"]="VERIFY "
	TOKEN["d7"]="BEEP "
	TOKEN["d8"]="CIRCLE "
	TOKEN["d9"]="INK "
	TOKEN["da"]="PAPER "
	TOKEN["db"]="FLASH "
	TOKEN["dc"]="BRIGHT "
	TOKEN["dd"]="INVERSE "
	TOKEN["de"]="OVER "
	TOKEN["df"]="OUT "
	TOKEN["e0"]="LPRINT "
	TOKEN["e1"]="LLIST "
	TOKEN["e2"]="STOP"
	TOKEN["e3"]="READ "
	TOKEN["e4"]="DATA "
	TOKEN["e5"]="RESTORE "
	TOKEN["e6"]="NEW"
	TOKEN["e7"]="BORDER "
	TOKEN["e8"]="CONTINUE"
	TOKEN["e9"]="DIM "
	TOKEN["ea"]="REM "
	TOKEN["eb"]="FOR "
	TOKEN["ec"]="GO TO "
	TOKEN["ed"]="GO SUB "
	TOKEN["ee"]="INPUT "
	TOKEN["ef"]="LOAD "
	TOKEN["f0"]="LIST "
	TOKEN["f1"]="LET "
	TOKEN["f2"]="PAUSE "
	TOKEN["f3"]="NEXT "
	TOKEN["f4"]="POKE "
	TOKEN["f5"]="PRINT "
	TOKEN["f6"]="PLOT "
	TOKEN["f7"]="RUN "
	TOKEN["f8"]="SAVE "
	TOKEN["f9"]="RANDOMIZE "
	TOKEN["fa"]="IF "
	TOKEN["fb"]="CLS"
	TOKEN["fc"]="DRAW "
	TOKEN["fd"]="CLEAR "
	TOKEN["fe"]="RETURN"
	TOKEN["ff"]="COPY"
	UDG["90"]="A"; UDG["91"]="B"; UDG["92"]="C"
	UDG["93"]="D"; UDG["94"]="E"; UDG["95"]="F"
	UDG["96"]="G"; UDG["97"]="H"; UDG["98"]="I"
	UDG["99"]="J"; UDG["9a"]="K"; UDG["9b"]="L"
	UDG["9c"]="M"; UDG["9d"]="N"; UDG["9e"]="O"
	UDG["9f"]="P"; UDG["a0"]="Q"; UDG["a1"]="R"
	UDG["a2"]="S"; UDG["a3"]="T"; UDG["a4"]="U"
	HI["0"]=0  ; LO["0"]=0
	HI["1"]=16 ; LO["1"]=1
	HI["2"]=32 ; LO["2"]=2
	HI["3"]=48 ; LO["3"]=3
	HI["4"]=64 ; LO["4"]=4
	HI["5"]=80 ; LO["5"]=5
	HI["6"]=96 ; LO["6"]=6
	HI["7"]=112; LO["7"]=7
	HI["8"]=128; LO["8"]=8
	HI["9"]=144; LO["9"]=9
	HI["a"]=160; LO["a"]=10
	HI["b"]=176; LO["b"]=11
	HI["c"]=192; LO["c"]=12
	HI["d"]=208; LO["d"]=13
	HI["e"]=224; LO["e"]=14
	HI["f"]=240; LO["f"]=15
}

function print_string( STRVAL )	{
	if( BYTE >= "90"  &&  BYTE <= "a4" )
		STRLEN = 1
	else
		STRLEN = length( STRVAL )
	if( WRAP == 64 )
	{
		if( (LP+STRLEN) > 64 )
		{
			# WRAP BY WORD AT 64 CHARS AND INDENT NEXT LINE
			printf( "\n     %s", substr(SPACES,1,INDENT) ); LP = 5+INDENT
		}
	}
	if( WRAP == 32 )
	{
		if( (LP+STRLEN) > 32 )
		{
			# WRAP BY CHARACTER AT 32 CHARS AND DON`T INDENT NEXT LINE
			printf( "%s\n", substr( STRVAL,1,32-LP ) )
			STRVAL = substr( STRVAL,32-LP+1 ); LP = 0
			STRLEN = length( STRVAL )
		}
	}
	printf( "%s", STRVAL ); LP+=STRLEN
}

{
	if( $1 == "*" )
	{
		# IF ALL BYTES ARE THE SAME, AND THE SAME AS THE PREVIOUS LINE,
		# THEN od JUST PRINTS A "*", SO THE LINE HAS TO BE EXPANDED.
		# FIRST, RE-SWAP THE BYTES OF THE LAST FIELD PRINTED;
		BYTS = sprintf( "%s%s", substr(BYT2,3,2), substr(BYT2,1,2) )
		# THEN PUT IT INTO $0 8 TIMES.
		for( FLD=2; FLD<=9; FLD++ )
			$(FLD) = BYTS
	}

	for( FLD=2; FLD<=9; FLD++ )
	{
		if( FLD > NF )
			exit

		PAIR++
		if( PAIR <= 12 )
		{
			# SKIP 1st 24 BYTES OF HEADER INFO
			continue
		}

		# SWAP THE BYTES
		BYT2 = sprintf( "%s%s", substr($(FLD),3,2), substr($(FLD),1,2) )
		for( BYTP=1; BYTP<=3; BYTP+=2 )
		{
			LB++; BYTE = substr( BYT2,BYTP,2 )

			# PROCESS A LINE NUMBER
			# BASIC LINE NUMBER BYTES ARE ARRANGED HI+LO
			if( LB == 1 )
			{
				LNNO =  (HI[substr(BYTE,1,1)] + LO[substr(BYTE,2,1)]) * 256
				continue
			}
			if( LB == 2 )
			{
				LNNO += (HI[substr(BYTE,1,1)] + LO[substr(BYTE,2,1)])
				if( LNNO > 9999 )
					exit
				printf( "%4d ", LNNO ); LP = 5; INDENT = 0
				continue
			}

			if( LB == 3  ||  LB == 4 )
			{
				# SKIP LENGTH BYTES
				continue
			}

			if( LB == 5 )
			{
				# IF THE LINE STARTS WITH A "REM" THEN WRAP TO 32 TO
				# RETAIN ANY COMMENT FORMATTING; OTHERWISE WRAP TO 64
				if( BYTE == "ea" )
					WRAP = 32
				else
					WRAP = 64
			}

			if( BYTE == "0e"  &&  BIN == 0 )
			{
				# SET EMBEDDED BINARY NUMBER FLAG & SKIP MARKER
				BIN = 1
				continue
			}
			if( BIN > 0 )
			{
				# SKIP EMBEDDED BINARY NUMBER
				if( BIN < 6 )
				{
					BIN++; continue
				}
				else
					BIN = 0
			}

			if( BYTE >= "10"  &&  BYTE <= "17"  &&  CTL != 1 )
			{
				# SET EMBEDDED PRINT CONTROL FLAG & SKIP MARKER
				# (THERE MAY BE MULTIPLE PRINT CONTROL PAIRS IN SEQUENCE)
				CTL = 1
				continue
			}
			if( CTL > 0 )
			{
				# SKIP EMBEDDED PRINT CONTROL
				if( CTL < 2 )
				{
					CTL++; continue
				}
				else
					CTL = 0
			}

			if( BYTE == "0d" )
			{
				# CR MARKS END OF LINE
				print	""
				LB = 0; LP = 0
				continue
			}

			if( BYTE >= "20"  &&  BYTE <= "7f" )
			{
				# REGULAR ASCII CHARACTER
				ASCII = (HI[substr(BYTE,1,1)] + LO[substr(BYTE,2,1)])
				print_string( sprintf( "%c", ASCII ) )
				continue
			}

			if( BYTE >= "a5" )
			{
				# EXPAND A TOKEN
				print_string( TOKEN[BYTE] )
				if( BYTE == "cb" )	#  = " THEN " - NEST "IF"s
				{
					INDENT+=2
					printf( "\n     %s", substr(SPACES,1,INDENT) )
					LP = 5+INDENT
				}
				continue
			}

			if( ARG == "-s" )
			{
				if( BYTE >= "80"  &&  BYTE <= "8f" )
				{
					# BLOCK GRAPHIC
					ASCII = (HI[substr(BYTE,1,1)] + LO[substr(BYTE,2,1)])
					print_string( sprintf( "%c", ASCII ) )
					continue
				}
				if( BYTE >= "90"  &&  BYTE <= "a4" )
				{
					# USER DESIGNED GRAPHIC - UNDERLINE A-U
					print_string( sprintf( "\033-1%s\033-0", UDG[BYTE] ) )
					continue
				}
			}

			# PRINT ANY UNRECOGNISED CHAR AS A "?"
			print_string( "?" )
			continue
		}
	}
}

END	{
	print	"** END OF FILE **"
}
