
loadat: equ  $e400           ;$ef00 (block X4, page 6)  or  $e400 (block T8, page 3)
        org  loadat
yloc:   equ  endcode         ;location of character defs
zloc:   equ  yloc+504        ;  829  or   504 : location of print control (= yloc + bytes in y$()
tct:    equ  0               ;   35  or     0 : entries in text character set
myt:    equ  8               ;    7  or     8 : bytes in a text character def
tctmyt: equ  tct*myt         ;size of text character set
myg:    equ  8               ;    4  or     8 : bytes in a graphic character def
zdim:   equ  148             ; 1206  or   148 : bytes in z$()

decode:
        push de
        ld   ix,23677        ;COORDS:x
        ld   bc,zdim/2       ;BC=rows in z$()
        ld   hl,zloc         ;HL=start of print control

nxtchr: push bc
        ld   a,(hl)
        cp   $ff
        jr   nz,nxtxco
        inc  hl
        ld   a,(hl)
        ld   (23678),a       ;COORDS:y
        jr   nxtchk

nxtxco: ld   (23677),a       ;COORDS:x
        inc  hl
        ld   e,myt
        ld   d,(hl)          ;D =d = character code (text)
        push hl
        ld   hl,yloc
        ld   a,d
        dec  a
        cp   tct
        jr   c,getchar

        ld   e,myg
        ld   hl,yloc+tctmyt
        ld   a,d
        sub  tct
        ld   d,a             ;D =d - tct = character code (graphic)

getchar:                     ;HL=y$ base row address for charset
        dec  d               ;D =d-1
        ld   b,d             ;B =char.def. row offset from charset base
        ld   (ix+4),e        ;  = 23681 = char.def. length
        ld   d,0
        jr   z,plotit        ;if offset=0

addoff: add  hl,de
        djnz addoff          ;HL=y$ row offset for char.def.

plotit: ;----------
        ex   de,hl           ;DE=location of char.def.
        push de
        ld   bc,(23677)      ;COORDS
        call $22aa           ;PIXEL_ADD
        sub  8
        neg
        ld   (23692),a       ;save pixel position
        exx
        ld   a,(23681)
        ld   b,a             ;B'=my
        pop  de
        ld   a,(de)
        exx
N0:     push hl
        ld   d,a             ;D=ABCDEFGH
        ld   e,0
        ld   B,$ff           ;B=%11111111
        ld   a,(23692)
N1:     sla  b
        sla  d
        rl   e
        dec  a
        jr   nz,N1
N2:     ld   a,(hl)          ;A=abcdefgh B=%11100000, E=000ABCDE, D=FGH00000
        or   e               ;A=abcABCDE
        ld   (hl),a
        inc  hl
        ld   a,l
        and  $1f
        jr   z,N9            ;skip 2nd byte if on next line
        ld   a,(hl)
        or   d               ;A=FGHlmnop
        ld   (hl),a
N9:     exx
        dec  b
        inc  de
        ld   a,(de)
        exx
        pop  hl
        jr   z,plotend
        ex   af,af'

hldown: inc  h               ;calculate address of next pixrow down
        ld   a,h
        and  $07
        jr   nz,endown
        ld   a,l
        sub  $e0
        ld   l,a
        sbc  a,a
        and  $f8
        add  a,h
        ld   h,a

endown: ex   af,af'
        jr   N0
        ;----------
plotend:pop  hl

nxtchk: pop  bc
        dec  bc
        inc  hl
        ld   a,b
        or   c
        jp   nz,nxtchr
        pop  de
        ret

endcode:

