; "dlp1" : Block-08 patch
        LD D, $03                ; 61B4 16 03         ;call put      23943     ;save system data for BASIC

; "dlp2" : Block-10 patches
        JR NZ, L_623F            ; 6237 20 06         ;         jp nz,restore ;C2 00 B3  ;45824
        LD IX, $3FCA             ;!6239 DD 21 CA 3F   ;write    ld hl,$3fca   ;21 CA 3F  ;redundant after patch

 L_62AF:PUSH IY                  ; 62AF FD E5         ;nop : nop
        JP $3D2F                 ;*62B1 C3 2F 3D      ;jp   bypass   23835     ;bypass disk access

; "dlp2" : Block-T7 patches
        JP L_B6D6                ; B6A3 C3 D6 B6      ;jp   bak2bas  23798     ;return to BASIC temporarily

        CALL $6227               ; B7E2 CD 27 62      ;call PATLX3             ;load from tape patch
        LD DE, ($AD45)           ; B7E5 ED 5B 45 AD   ;(swapped)
        CALL L_B873              ; B7E9 CD 73 B8      ;call PATLX1             ;load from tape patch

        JP L_BB1B                ; B82E C3 1B BB      ;jp   PATCHS             ;save to tape patch



; BASIC lines 11 & 15 in "dlp2" are loaded as a single code block "dc2"
; starting at 23789 from the first line number to the second ENTER.

; ----------  bak2bas + bypass + copcod -- are in "dlp2" line 11
get_t7: equ  46416
        org  23789
        defb 0,11,74,0,234,"x",22
        defw $100c
        ;    23798
bak2bas:LD   HL, $6190
        LD   SP, HL
        pop  bc
        jp   23964      ;get ;return to BASIC temporarily
        ;    23806
retfbas:LD   HL, $bff4       ;restore SP
        LD   SP, HL
        ld   hl,$b6a4
        ld   (hl),$d6        ;restore "JP $B6D6"
        inc   hl
        ld   (hl),$b6
        ld   a,6             ;set yellow ink for middle screen
        ld   hl,$58c0
        ld   de,$58c1
        ld   bc,$013f
        ld   (hl),a
        ldir
        JP   get_t7          ;return to Doom (indirectly)
        ;    23835
bypass: ld   a,iyh           ;to bypass disk access
        cp   $20
        ret  nz
        pop  af
        pop  af
        ret
        ;    23843 ($5d23)   ;copy code from block09:$c030 into line 15 REM at $5d40
copcod: ld   hl,49200        ;$c030
        ld   de,23872
        ld   bc,71
        ldir
        ret

        ;    23855 ($5d2f)
        defs 11
; ENTER + 4 bytes + REM then next code starts at 23872
        defb $0d,0,15,255,0,234
        ;    23872 ($5d40)
        defs 71

; ----------  put + get + reset + xfiles -- are in "dlp2" line 15
; ----------  after 71 bytes copied from Block-09 --------------------------
saved:  equ  45968
        ;    23943
put:    ld   d,3             ;save system data for BASIC
        exx
        ld   hl,get
        ld   ($618d),hl
        ld   hl,23296
        ld   de,saved
getput: ld   bc,$c0
        ldir
        ret
get:    ;    23964
        ld   hl,saved
        ld   de,23296
        ld   bc,$2d2b
        push bc
        exx
        ld   hl,$2758
        exx
        jr   getput
        ;    23981
reset:  EI                   ; (copied from $5dd4) 44 bytes
        HALT
        XOR A
        OUT ($FE), A
        LD HL, $5AFF
        LD DE, $5AFE
        LD BC, $1B00
        LD (HL), C
        LDDR                 ;clear $4000-$5aff (display)
        LD BC, $7FFD
        LD A, $17
        OUT (C), A           ;page 7
        LD HL, $C000
        LD DE, $C001
        LD BC, $1AFF
        LD (HL), L
        LDIR                 ;clear $c000-$daff in page 7
        LD BC, $7FFD
        LD A, $10
        OUT (C), A           ;page 0
        RET

;          @ indicates a fixed position        @@@@       @@@@@@@@@
;          C123456789abcdefD123456789abcdefE123456789abcdefF123456789abcdef
; page0 T2 xxxxxxxxxxxxxxxxxxxxxxxx?ffffffff              44444444477777777
; page1 T3 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx8888?!!!!!!!!!!!!!!!!!!!!!!!
; page3 T4 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx wwwwwwww
; page4 T5 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; page6 T6 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx ccccccccccc 1222559 !!!!!!!!
; page7 TA xxxxxxxxxxxxxxxxxxxxxxxxxxxx    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; Block X1     $6640-$673f
; Block X2     $6800-$6aff

;       org  24025 ;-- address --          backup        HL     DE    B ($b207)
;       disk sector active backup   size    page       start  tr/se  #se  page   size

xfiles: defw $2308, 26176,  $f000,   256 ;X1 .6.       $6640   2308   01   17     256 =
        defw $2309, 26624,  $f100,   768 ;X2 .6.       $6800   2309   03   17     768 =
        defw $210c, $c000,  $c000,  7168 ;X3 .7.       $c000   210c   1c   17    7168 = overwritten by TA
        defw $2001, 16384,  $ef00,  2304 ;X4 .0.packed $4000   2001   10   16    4096 =
        defw $2101, 22528,  $f400,   512 ;X5 .6.       $5800   2101   02   16     512 =
        defw $2001, $c000,      0,  8960 ;T6 n/a
        defw $1d0d, $b680,  $f800,  2048 ;T7  0        $b680   1d0d   08   17/6  2048 =
        defw $2103, 16384,  $e400,  1024 ;T8  1.packed $4000   2103   08   11/6  2048 =
        defw $210b, 22528,  $f600,   256 ;T9  6        $5800   210b   01   16     256 =
        defw $1e05, $c000,  $c000,  7168 ;TA  7        $c000   1e05   1c   17    7168 = overwrites X3
xpageb: defb 16+6,16+6,16+7,16+0,16+6,16+0,16+0,16+1,16+6,16+7  ;backup page
xpagea: defb 16+7,16+7,16+7,16+6,16+6,16+6,16+7,16+1,16+6,16+7  ;active page
        defb $0d             ;end of line 15


; ----------  swapit + savex  ---------- are in CODE "dc3"
xfiles: equ  24025
xpageb: equ  24105
xpagea: equ  24115

        org  45824
;patch to jump here from $6237 is not entered until first menu is displayed
restore:call swapit
        ld   a,$80
        jp   $623F

;also called from "dlp2" when initially loading program data
;       copy a code/data block from backup to active location
;bank switch code is held in {$B207, CALL $8996) not BANKM
swapit: push bc              ;search for match in block parameters
        push de              ;DE=sector number to match in xfiles table
        push hl
        ld   bc,8
        ld   ix,xfiles-8
        ld   hl,xpageb-1

nexthl: add  ix,bc
        inc  hl
        ld   a,(ix+0)
        cp   e
        jr   nz,nexthl
        ld   a,(ix+1)
        cp   d
        jr   nz,nexthl

        ld   a,(hl)          ;A =backup (source) page code
        ex   af,af'
        ld   c,10
        add  hl,bc
        ld   a,(hl)          ;A'=active (destination) page code
        ex   af,af'

        ld   e,(ix+2)
        ld   d,(ix+3)        ;DE=active location
        ld   hl,$4000
        sbc  hl,de           ;check if it's a screen block
        ld   l,(ix+4)
        ld   h,(ix+5)        ;HL=backup location
        jr   nz,gocopy
        call $8996           ;swap in required page
        call $006f           ;does JP (HL) to screen unpacking routine
        jr   endcopy

gocopy: push de
        ld   c,0
        ld   b,(ix+7)        ;BC=length (multiple of 256)
        exx
        pop  de              ;D'E'=active location
        push hl              ;save H'L'
        exx

docopy: push bc
        ld   de,swapped
        call swapit3         ;swap in backup page & copy sector from backup page
        ld   hl,swapped
        call swapit3         ;swap in active page & copy sector to active page
        pop  bc
        djnz docopy

        exx
        pop  hl              ;restore H'L'
        exx
endcopy:pop  hl
        pop  de
        pop  bc
        ret

swapit3:call $8996           ;swap in required page
        ld   bc,256
        ldir                 ;copy next sector
        ex   af,af'
        exx
        ret

; This routine gets replaced later on by the cassette save/load patches
;       org  45938           ;VAL "45938+(a-6 AND a>=7)"
savex:  ret                  ;entry point  for blocks X1-X5,T6
        ;otherwise,          ;entry points for blocks T7-TA
        defb 0,0,0,0         ;}required padding
        ; BC holds RANDOMIZE USR address:
        ;    45939 = $B373    subtract $6D from C to give A = (7->10) - 1
        ;find xfiles entry & copy block to active location
        ld   a,c
        sub  $6d             ;A =xfiles row offset
        add  a,a
        add  a,a
        add  a,a             ;A =block parameters offset
        ld   hl,xfiles
        ld   b,0
        ld   c,a
        add  hl,bc           ;HL=block parameters address
        ld   e,(hl)
        inc  hl
        ld   d,(hl)          ;DE=sector number
        ld   a,(23388)       ;A =(BANKM)
        LD  ($B207),A        ;synchronise with program's own bank switch code
        jp   swapit

       ;org  45968
saved: ;defs 192             ;save area for system data from $5b00, etc. (192 bytes)
swapped:equ  saved+192       ;transit area for page copies (256 bytes)



; ----------  get_t7 + pats + patlx1 + patlx3  ---------- are in CODE "dc4"
xfiles: equ  24025
xpageb: equ  24105
xpagea: equ  24115
savex:  equ  45938

        org  46416           ;45968+192+256
;       recover block T7
get_t7  ld   hl,xpageb+6
        ld   a,(hl)          ;A =backup page#
        call $8996           ;swap in backup page
        ld   bc,48
        ld   ix,xfiles
        add  ix,bc           ;IX=block parameters address

        ld   hl,PATCHT7      ;copy tape patches into block T7
        ld   de,$b82e        ;before restoring to backup location
        ld   c,3
        ldir
        ld   de,$b7e2
        ld   c,10
        ldir
        ld   de,$b775
        ld   c,3
        ldir
        ld   de,savex        ;copy tape patches to a safe area
        ld   c,59
        ldir

        ld   l,(ix+2)
        ld   h,(ix+3)        ;HL=active location
        ld   e,(ix+4)
        ld   d,(ix+5)        ;DE=backup location
        ld   c,(ix+6)
        ld   b,(ix+7)        ;BC=length
        ldir

        JP   $b6d9           ;return to Doom loader

shift:  equ  savex-PATS
PATCHT7:jp   PATS+shift      ;$b82e ;save patch

        CALL PATLX3+shift    ;$b7e2 ;load patch
        LD DE, ($AD45)
        CALL PATLX1+shift

        CALL PATLX3+shift    ;$b775 ;new game patch

        ;disk saves in reverse order to load, but tape must save in same order
PATS:   call $b831           ;save to tape patch
        ld   a,$ff
        ld   ix,$c000
        ld   de,7168
        call $04c2
        ld   a,$ff
        ld   ix,$6640
        ld   de,256
        call $04c2
        jp   $bb1b

PATLX3: ;load from tape patches
        scf
        ld   a,$ff
        ld   ix,$c000
        ld   de,7168
        jp   $0556
PATLX1:
        scf
        ld   a,$ff
        ld   ix,$6640
        ld   de,256
        jp   $0556


; END ************


