

        org  $9710      ;38672 (page 2)

        ;set up DOS environment
OpWolfLoader:
        ld   SP,$9a00
        ld   a,7
        call PageIn
        push iy

;    page 1: 31 buffers unavailable; last buffer in page (almost) available
;            need to preserve 25 bytes at end of page
;    1st DOS buffer $1f @ 1:$fe00
;            number $01 = $0200 bytes
;    1st RAM buffer $40 @ 3:$c000
;            number $00

;        7:$c000<-->$c05f XXXX (  96 bytes) used by +3 BASIC }shadow
;        7:$c060<-->$daff free (6816 bytes)                  }screen
;        7:$db00<-->$e7ff XXXX (3328 bytes) used by +3 DOS
;        7:$fe00<-->$ffff used to load bootsector by +3 DOS ROM; otherwise:
;        7:$e800<-->$ffff free unused by +3 DOS after boot (6144 bytes, 6kb)

        ld   de,$1f01   ;use 1 DOS buffer  #$1f (page 1:$fe00-$ffff)
        ld   hl,$2000   ;use 0 RAM buffers
        call $013f      ;DOSSET1346
        jp   nc,ENDOPW
        ld   iy,FILEDATA

NextBlock:
        ld   a,(iy+01)
        cp   $ff
        scf
        jr   z,DUNOPW

        ld   (FILENAME),a
        call PageOut    ;switch to 48k ROM for PR-STRING
        ld   de,ATTRNAME
        ld   bc,6
        push iy
        ld   iy,$5c3a
        call $203c      ;PR-STRING
        pop  iy
        ld   a,7
        call PageIn     ;return to +3 DOS ROM
        ld   bc,$0301   ;file#=3, access=read
        ld   de,$0001   ;create=0, open=1
        ld   hl,FILENAME
        call $0106      ;DOS_OPEN
        jr   nc,ENDOPW

READIT: ld   b,3        ;file#=3
        ld   c,(iy+00)  ;page
        ld   l,(iy+02)
        ld   h,(iy+03)  ;HL=read address
        ld   e,(iy+04)
        ld   d,(iy+05)  ;DE=bytes to read
        call $0112      ;DOS_READ
        jr   nc,ENDOPW

        ld   b,3        ;file#=3
        call $0109      ;DOS_CLOSE
        jr   nc,ENDOPW
NEXTFILE:
        ld   bc,6
        add  iy,bc
        jr   NextBlock

DUNOPW: jr   nc,ENDOPW
        ;copy $7905,$4000,$0d00 to $7907,$db00,$0d00
        ld   hl,$4000
        ld   de,$db00
        ld   bc,$0d00
        ldir
        ;blank screen &
        ;erase 128k system variables (last 256 bytes of file 'e')
        LD   HL,$5800
        LD   DE,$5801
        LD   BC,$03FF
        LD   (HL),L
        LDIR
        scf             ;flag OK
        ;restore BASIC environment
ENDOPW: pop  iy
        push af
        call nc,$0100   ;DOS_INITIALISE (after error)
        call PageOut
        pop  af
;-----
        jr   c,RUNOPW
        ld   b,0
        ld   c,a
        ret             ;return error
;-----

PageIn: di              ;switch to +3 DOS ROM, page A
        ld   c,a
        ld   a,($5b5c)  ;BANKM (23388)
        and  %11101000
        or   c
        ld   ($5b5c),a
        ld   bc,$7ffd   ;32765
        out  (c),a
        ei
        ret

PageOut:di              ;switch to 48k ROM, page 0
        ld   a,($5b5c)  ;BANKM (23388)
        set  4,a
        and  %11111000
        ld   ($5b5c),a
        ld   bc,$7ffd   ;32765
        out  (c),a
        ei
        ret

;----- Run: Firstly, copy the finishing code into the display file
;           so that the area occupied by this routine can be restored.
RUNOPW: di
        LD   D,$10
        LD   HL,$8798
        EXX
        LD   SP,$5CD7
        LD   HL,GOTOP1  ;was $FD1F
        LD   DE,$51f5   ;was $5200
        LD   BC,GOTOP2-GOTOP1
        LDIR
        JP   $51f5      ;was $5200

GOTOP1: LD   BC,$1FFD
        LD   A,%00000100
        OUT  (C),A

        ;restore areas overwritten by loader
        LD   BC,$7FFD
        LD   A,%00010001
        OUT  (C),A      ;48k ROM, RAM page 1 (DOS buffer)
        ld   hl,$fe00
        ld   (hl),$00
        ld   de,$fe01
        ld   bc,512-25-1
        ldir
        ld   hl,PAGE1DATA
        ld   c,$19
        ldir

        LD   BC,$7FFD
        LD   A,$12
        OUT  (C),A      ;48k ROM, RAM page 2 (loader code - this program)
        ld   hl,$9710
        ld   (hl),$00
        ld   de,$9711
        ld   bc,496-1
        ldir
        inc  hl
        inc  de
        ld   (hl),$5d
        ld   bc,257-1
        ldir

        LD   HL,$2758
        EXX
        LD   BC,$7FFD
        LD   A,D        ;A =D =$10
        OUT  (C),A      ;48k ROM, RAM page 0
        JP   (HL)
GOTOP2:
;-----

ATTRNAME:
        defb $16,$00,$00,$10,$02  ;AT 0,0;INK red
FILENAME:
        defb "?"        ;replaced with file letter
        defb $ff        ;end-of-name
FILEDATA:
;       defw $6505,$4000,$1b00 : loaded from BASIC
        defw $6103,$c000,$4000
;       defw $6202,$8000,$0200, $6302,$8500,$0200 : not needed
        defw $6403,$fed3,$012d
;       defw $6802,$8000,$4000 : loaded from BASIC
        defw $6903,$c000,$3000, $6a00,$c000,$4000
        defw $6b01,$c000,$3e00 ; actual length is $4000; using last 512 bytes as temp.DOS buffer
        defw $6c04,$c000,$4000, $6e06,$c000,$4000
        defw $6f03,$f000,$1000 ; originally loaded to $4000, but copied to top of page 3 later
        defw $6605,$5cd8,$0800, $6705,$632f,$1cd1
;2001 DATA "x",6912,"y",3328,"z",6144 : REM blocks for page 7
;middle block initially loaded into page 5 (loaded last)
;       defw $7807,$c000,$1b00, $7a07,$e800,$1800, $7907,$db00,$0d00
        defw $7807,$c000,$1b00, $7a07,$e800,$1800, $7905,$4000,$0d00
        defw $ff00
PAGE1DATA:
        ; data to be restored at the end of file 'k' (for page 1)
        defb $EA,$E2,$4D,$E3,$99,$E3,$00,$E1,$05,$E4,$40,$E7,$80,$E7,$88,$E7,$98,$E2,$A3,$E2,$C3,$E2,$D6,$E2,$09
EndLoader:
;-----
