

; **********
; "sg+3" CODE

        ORG  32768

SG_Plus3_Loader:
        LD   SP,36864             ;$9000
        call PageIn
LoadStart:
        LD   HL,HEADSA_H          ;HL=header table address
Load8Files:
        LD   A,(HL)               ;A =data load page
        cp   $ff
        JR   Z,Done8Files
        PUSH HL
        INC  HL
        LD   E,(HL)
        INC  HL
        LD   D,(HL)               ;DE=data load address
        INC  HL                   ;HL points to file name
        CALL LoadFile
        POP  HL
        JR   NC,LoadStart         ;if loading error
        ld   a,(hl)
        cp   2
        jr   nz,LoadNextFile
        push hl
        ld   hl,$9b00
        ld   de,SAVEFG            ;SAVEFG(lo)
        ld   bc,$0100
        ldir                      ;save MAIN1(head) to SAVEFG(lo)
        ld   de,$5b00+$0100
        ld   bc,$2500-$0100
        ldir                      ;move remainder to correct location
        pop  hl
LoadNextFile:
        LD   DE,9
        ADD  HL,DE
        JR   Load8Files

HEADSA_H: ;      [load@] header table                         loads at: length
        defb $05,$00,$40,$53,$43,$52,$45,$45,$ff ; ..@SCREE. $4000 16384+ 5639
       ;defb $05,$00,$5B,$4D,$41,$49,$4E,$31,$ff ; ..[MAIN1. $5b00 23296+ 8652
        defb $02,$00,$9B,$4D,$41,$49,$4E,$31,$ff ; ..[MAIN1. move to $5b00 after Unpack
        defb $00,$00,$A0,$4D,$41,$49,$4E,$32,$ff ; ..MAIN2. $a000 40960+16361
        defb $01,$00,$C0,$42,$41,$4E,$4B,$31,$ff ; ..BANK1. $c000 49152+15657
        defb $03,$00,$C0,$42,$41,$4E,$4B,$33,$ff ; ..BANK3. $c000 49152+14421
        defb $04,$00,$DF,$42,$41,$4E,$4B,$34,$ff ; ..BANK4. $df00 57088+ 8246
        defb $06,$00,$C0,$42,$41,$4E,$4B,$36,$ff ; ..BANK6. $c000 49152+14188
       ;defb $07,$00,$DB,$42,$41,$4E,$4B,$37,$ff ;...BANK7. $db00 56064+ 5509 + 9472 (unpk) = 65536
        defb $07,$00,$C0,$42,$41,$4E,$4B,$37,$ff ;...BANK7. move to $db00 after Unpack
        defb $ff                                 ;   BANK7 overwrites DOS workspace

        ;jumps here after loading 8 data files listed in header table
Done8Files:
        ld   de,65535
        ld   hl,49152+9472-1
        ld   bc,9472
        lddr                      ;move BANK7 into correct place (overwrites DOS workspace)
        call SwapFG               ;restore MAIN1(head) from SAVEFG(lo) & save +3 system area to SAVEFG(lo)
        call PageOut              ;page 4, ROM 3 (BASIC)
        ld   hl,SAVEFG
        ld   de,SAVEFG+OFFNEW+OFFOLD
        ld   bc,$0100
        ldir                      ;move +3 system area from SAVEFG(lo) to page 4:SAVEFG(hi)

        ;INSTALL LOADING PATCHES !!
        ld   b,27
        ld   hl,PATCHEND-1
PATCH_N:ld   d,(hl)
        dec  hl
        ld   e,(hl)
        dec  hl
        ld   a,(hl)
        ld   (de),a
        dec  hl
        ld   a,(hl)
        dec  de
        ld   (de),a
        dec  hl
        djnz PATCH_N
        ;loop to insert $ff terminators for file names in SGTAPloadin.ASM header table
        ld   hl,$a6b9+OFFOLD
        ld   bc,$a790-$a6b9
LOOPF1: xor  a
        inc  hl
        inc  hl
        dec  bc
        dec  bc
        cpir
        jr   nz,LOOPEX
        dec  hl
        inc  bc
        ld   (hl),$ff
LOOPF2: inc  hl
        dec  bc
        ld   a,(hl)
        cp   $ff
        jr   z,LOOPF2
        ld   a,b
        or   c
        jr   nz,LOOPF1
        ;copy new section to inactive area in page 4
LOOPEX: ld   hl,INGAME
        inc  (hl)                 ;flag "in game"
        ld   hl,LoadFile
        ld   de,$a915+OFFOLD
        ld   bc,SAVEND-LoadFile
        ldir
        jp   27479                ;$6b57

OFFNEW: equ  $a915-LoadFile
OFFOLD: equ  $3900

PATCHES:
        ;patches to marked !! lines in SGTAPloadin.ASM
        defw $3100,$6b58, $bfbe,$6b5a
        defw PageIntro+OFFNEW,$a641+OFFOLD+1, PageOutro+OFFNEW,$a647+OFFOLD+1
        defw PageIntro+OFFNEW,$a662+OFFOLD+1, PageOutro+OFFNEW,$a671+OFFOLD+1
        defw $0000,$a8f5+OFFOLD+1, $0000,$a8f6+OFFOLD+1
        defw $a915,$a902+OFFOLD+1, $ff3e,$a908+OFFOLD+1
        ;patches to LoadFile below
        defw HEAD16+OFFNEW,LF1+1+1
        defw LEPACK+OFFNEW,LF2+2+1, LEPACK+OFFNEW,LF4+2+1
        defw LEUNPK+OFFNEW,LF3+1+1, UNPACK+OFFNEW,LF5+1+1
        defw PAGE_A+OFFNEW,LFH1+1+1, PAGE_A+OFFNEW,LFH2+1+1
        ;patches to DOS paging routines below
        defw SwapFG+OFFNEW,PI_3+1+1, INGAME+OFFNEW,PI_1+1+1
        defw PAGE_H+OFFNEW,PI_0+1+1, PAGE_H+OFFNEW,PO_0+1+1
        defw INGAME+OFFNEW,PO_1+1+1, SwapFG+OFFNEW,PO_3+1+1
        defw PAGE_A+OFFNEW,SwapFG+3+1, SAVEFG+OFFNEW+OFFOLD,SwapFG+8+1, PAGE_A+OFFNEW,FGSwap+3+1
        ;patch to UNPACK below
        defw UNPK01+OFFNEW,UNPK02+3+1

PATCHEND:

;In page 7 DOS uses 56064->59391 ($db00->$e7ff) = 3328 ($d60)  bytes
;shadow screen uses $c000->$daff

; **********
; remainder inserted in redundant segment:
; inactive  $a915+$3900; copied to ...
;   active  $a915->$ab47 can be replaced (= $232 (562) bytes)

          ;on entry, HL = file name address
          ;          DE = load address
          ;          A  = page#
LoadFile: ;lines marked '**' use absolute addresses
        push de
        push af
        ld   bc,$0301             ;file ID#3, access: 1=read
        ld   de,$0002             ;create=0, open=2
        call $0106    ;DOS_OPEN
        jr   nc,LoadError
        ld   bc,$0302             ;file ID#3, page=2
LF1:    LD   HL,HEAD16         ;**;address to load 16-byte headers   !!
        LD   DE,16                ;DE=load length
        call $0112    ;DOS_READ:  ;load a header block
        jr   nc,LoadError
        ld   b,3                  ;file ID#3
        pop  af
        ld   c,a                  ;page#
        pop  hl                   ;HL=load address
        push hl
        push af
LF2:    LD   DE,(LEPACK)       ;**;DE=load length                    !!
        call $0112    ;DOS_READ:  ;load a program data block
        jr   nc,LoadError
        ld   b,3                  ;file ID#3
        call $0109    ;DOS_CLOSE
        jr   nc,LoadError
        pop  af                   ;A =page#
        pop  de
        di
LFH1:   call PAGE_A            ;!!
LF3:    LD   HL,(LEUNPK)       ;**                                   !!
        ADD  HL,DE
        DEC  HL
        EX   DE,HL
LF4:    ld   bc,(LEPACK)       ;**                                   !!
LF5:    CALL UNPACK            ;**;unpack data block                 !!
        ld   a,7
LFH2:   call PAGE_A            ;!!
        ld   c,$ff
        scf
        RET
LoadError:
        pop  af
        pop  de
        and  a
        ret

SwapFG: ld   a,%00010100     ;ROM 3, RAMpage 4
        call PAGE_A          ;!!
        ld   b,0             ;swap 256 bytes between $5b00 <-> saved +3 system area (SAVEFG(hi))
        ld   hl,SAVEFG       ;!!
        ld   de,$5b00
LoopFG: ld   a,(de)
        ld   c,a
        ld   a,(hl)
        ld   (de),a
        ld   (hl),c
        inc  hl
        inc  de
        djnz LoopFG
FGSwap: ld   a,%00000111     ;ROM 2, RAMpage 7
        call PAGE_A          ;!!
        ret

PageIntro:
        CALL $A790
PageIn: di
        im   1
        ld   iy,$5c3a   ;print routine at $61f5 changes IY
        ld   a,($5b5c)  ;BANKM (23388)
        res  4,a
        ld   h,7
PI_0:   call PAGE_H     ;page 7, ROM 2 (DOS)!!
        XOR  A
        OUT  (254),A
        LD   HL,$5800
        LD   DE,$5801
        LD   BC,$2ff
        LD   (HL),A
        LDIR                      ;erase screen
PI_1:   ld   a,(INGAME) ;!!
        or   a
        jr   z,DOSInit
PI_3:   call SWAPFG     ;swap in +3 system variables!!
        ld   hl,$db00
        ld   de,$4000
        ld   bc,$0d60
        ldir            ;save page 7 $db00->$e7ff

DOSInit:ld   hl,$db00
        ld   de,$db01
        ld   bc,$09ff
        ld   (hl),$00
        ldir                ; clear DOS workspace variables
        call $1f32          ; DD_INIT
        call $17d0          ; initialise A: & B: extended XDPBs
        ld   hl,$0000       ; no RAMdisk, no cache
        ld   d,h
        ld   e,l
        push de
        call $1820          ; initialise RAMdisk
        pop  de
        call $1539          ; setup cache
        jp   $0500          ; set default drive and exit

PageOutro:
        ld   a,1
        jr   PageOwt
PageOut:xor  a
PageOwt:di
        ex   af,af'
PO_1:   ld   a,(INGAME) ;!!
        or   a
        jr   z,PO_2
        ld   hl,$4000
        ld   de,$db00
        ld   bc,$0d60
        ldir            ;restore page 7 $db00->$e7ff
PO_3:   call SWAPFG     ;swap out +3 system variables!!
        im   2
PO_2:   ld   a,($5b5c)  ;BANKM (23388)
        set  4,a
        ld   h,4
PO_0:   call PAGE_H     ;page 4, ROM 3 (BASIC)!!
        ei
        ex   af,af'
        or   a
        ret  z
        CALL $A874
        ret
; ^
; **********
PAGE_H: AND  %11111000
        OR   H
        LD   ($5b5c),A
        ld   ($6568),a
PAGE_A: LD   BC,$7FFD
        OUT  (C), A
        RET
INGAME: defb $00
; **********

        ;on entry, HL = packed data load address
        ;          DE = unpacked data end address [HL + (LEUNPK) - 1]
        ;          BC = packed data length
UNPACK: ADD  HL,BC               ;unpack data block
        DEC  HL
        DEC  HL
        DEC  HL
        LD   A,(HL)
        EX   AF,AF'               ;A'=3rd byte from end of data (N)             $80=($5604)
        DEC  HL
        LD   A,(HL)               ;A =4th byte from end of data (N-1)           $82=($5603)
        DEC  HL                   ;HL=5th byte from end of data address =N-2        ($5602)
        DEC  BC
        DEC  BC
        DEC  BC
        DEC  BC                   ;BC=program data length - 4                   $1603
UNPK01: CP   (HL)                 ;compare byte (N-1) to byte (N-2)             $82:($5602)
        JR   Z,UNPK03
UNPK02: LDD                       ;if different, copy (HL) to (DE)
        JP   PE,UNPK01            ;if BC<>0
        RET

UNPK03: EX   AF,AF'               ;if the same
        DEC  HL
        CP   (HL)                 ;compare byte (N) to byte (N-3)               $80:($5601)
        JR   Z,UNPK04
        INC  HL                   ;if different, go back & copy previous byte
        EX   AF,AF'
        JR   UNPK02

UNPK04: PUSH AF                   ;if the same - $80
        PUSH BC                   ;$1603
        DEC  HL
        LD   A,(HL)               ;$40=($5600)
        DEC  HL
        LD   B,(HL)               ;$43=($55ff)
        DEC  HL                   ;$55fe
UNPK05: LD   (DE), A              ;($5aff)=$40
        DEC  DE                   ;$5afe
        DJNZ UNPK05               ;$43 - $01 = $42
        POP  BC
        DEC  BC
        DEC  BC
        DEC  BC
        DEC  BC
        LD   A,B
        OR   C
        JR   Z,UNPK06
        POP  AF
        EX   AF,AF'
        JR   UNPK01
UNPK06: POP  AF
        RET

HEAD16: ;16 bytes load area for file headers
HDNAME: defs 8
LEPACK: defs 2
LEUNPK: defs 2
CSDATA: defs 2
CSHEAD: defs 2

; **********

SAVEFG:;defs 256   ;saved $5b00-$5bff
SAVEND: