
; **********
; "sg" CODE

        DI                       ; 32768 243
        LD SP, 36864             ; 32769 49  0   144
        LD BC, 32765             ; 32772 1   253 127  ;$7ffd
        LD A, 16                 ; 32775 62  16       ;$10 = ROM 3, page 0
        OUT (C), A               ; 32777 237 121
        NOP                      ; 32779 0            }TAP loader POKEs zeroes here,
        NOP                      ; 32780 0            }
        NOP                      ; 32781 0            }
        NOP                      ; 32782 0            }
        NOP                      ; 32783 0            }
        NOP                      ; 32784 0            }but they're already zero
        NOP                      ; 32785 0            }
        NOP                      ; 32786 0            }
        NOP                      ; 32787 0            }
        NOP                      ; 32788 0            }
        NOP                      ; 32789 0            }in the CODE file
        JP L32793                ; 32790 195 25  128  redundant
L32793: XOR A                    ; 32793 175
        OUT (254), A             ; 32794 211 254
        LD HL, 16384             ; 32796 33  0   64
        LD DE, 16385             ; 32799 17  1   64
        LD BC, 6911              ; 32802 1   255 26
        LD (HL), A               ; 32805 119
        LDIR                     ; 32806 237 176      erase screen
        LD HL, 32866             ; 32808 33  98  128  HL=header table address
L32811: PUSH HL                  ; 32811 229
        LD A, (HL)               ; 32812 126
        INC A                    ; 32813 60
        JR Z, L32857             ; 32814 40  41
        DEC A                    ; 32816 61
        CALL L33093              ; 32817 205 69  129  switch in RAM page A
        NOP                      ; 32820 0
        NOP                      ; 32821 0
        INC HL                   ; 32822 35
        LD E, (HL)               ; 32823 94
        INC HL                   ; 32824 35
        LD D, (HL)               ; 32825 86           DE=data load address
        INC HL                   ; 32826 35
        LD BC, 65535             ; 32827 1   255 255
        CALL L32939              ; 32830 205 171 128  to 32966
        POP HL                   ; 32833 225
        JR NC, L32842            ; 32834 48  6        if loading error
        LD DE, 9                 ; 32836 17  9   0
        ADD HL, DE               ; 32839 25
        JR L32811                ; 32840 24  225

L32842: LD BC, 10000             ; 32842 1   16  39   border flashing loop after tape error
L32845: OUT (254), A             ; 32845 211 254
        INC A                    ; 32847 60
        AND 7                    ; 32848 230 7        00000111
        DJNZ L32845              ; 32850 16  249
        DEC C                    ; 32852 13
        JR NZ, L32845            ; 32853 32  246
        JR L32811                ; 32855 24  210

        ;jumps here after loading 8 data files listed in header table at 32866
L32857: XOR A                    ; 32857 175          A =0
        CALL L33093              ; 32858 205 69  129  switch in RAM page 0
        NOP                      ; 32861 0
        NOP                      ; 32862 0
        JP 23596                 ; 32863 195 44  92   TAP loader POKEs 0,144 (36864)

L32866:32866[load@] header table                 loads at: length
00000062  00[00 40]53 43 52 45 45 00  ..@SCREE. $4000 16384+ 5639
      6b  00[00 5B]4D 41 49 4E 31 00  ..[MAIN1. $5b00 23296+ 8652
00000074  00[00 A0]4D 41 49 4E 32 00  ..MAIN2. $a000 40960+16361
      7d  01[00 C0]42 41 4E 4B 31 00  ..BANK1. $c000 49152+15657
00000086  03[00 C0]42 41 4E 4B 33 00  ..BANK3. $c000 49152+14421
0000008f  04[00 DF]42 41 4E 4B 34 00  ..BANK4. $df00 57088+ 8246
      98  06[00 C0]42 41 4E 4B 36 00  ..BANK6. $c000 49152+14188
000000A1  07[00 DB]42 41 4E 4B 37 00 ...BANK7. $db00 56064+ 5509 + 9472 (unpk) = 65536
      aa  ff                            BANK7 overwrites DOS workspace

In page 7 DOS uses 56064->59391 ($db00->$e7ff) = 3328 ($d60)  bytes
shadow screen uses $c000->$daff

L32939: JP L32966                ; 32939 195 198 128
;        LD A, 201                ; 32942 62  201
;        LD (65535), A            ; 32944 50  255 255
;        CALL 65535               ; 32947 205 255 255  dummy call to find current PC
;        DEC SP                   ; 32950 59
;        DEC SP                   ; 32951 59
;        POP HL                   ; 32952 225          HL=PC-2
;        LD BC, 11                ; 32953 1   11  0
;        AND A                    ; 32956 167
;        SBC HL, BC               ; 32957 237 66       HL=address of L32939
;        LD D, H                  ; 32959 84
;        LD E, L                  ; 32960 93
;        LD BC, 459               ; 32961 1   203 1
;        ADD HL, BC               ; 32964 9            HL=address of L33398
;        JP (HL)                  ; 32965 233

; **********
; v     ; $80c6->$8144 (32966->33092) matches runner $a930->$a9ae

L32966: LD A, I                  ; 32966 237 87
        PUSH AF                  ; 32968 245
        DI                       ; 32969 243
L32970: PUSH DE                  ; 32970 213
        PUSH HL                  ; 32971 229
        LD HL, 33382             ; 32972 33  102 130       address to load 16-byte headers
        PUSH HL                  ; 32975 229
        LD DE, 16                ; 32976 17  16  0         DE=load length
        CALL L33069              ; 32979 205 45  129       load a header file
        POP HL                   ; 32982 225
        LD DE, 14                ; 32983 17  14  0
        CALL L33262              ; 32986 205 238 129       verify checksum
        LD DE, (33396)           ; 32989 237 91  116 130
        AND A                    ; 32993 167
        SBC HL, DE               ; 32994 237 82
        POP HL                   ; 32996 225
        POP DE                   ; 32997 209
        JR NZ, L32970            ; 32998 32  226           checksum mis-match
        PUSH DE                  ; 33000 213
        PUSH HL                  ; 33001 229
        LD B, 8                  ; 33002 6   8
        LD DE, 33382             ; 33004 17  102 130
        CALL L33233              ; 33007 205 209 129       search header table for matching row
        POP HL                   ; 33010 225
        POP DE                   ; 33011 209
        JR NC, L32970            ; 33012 48  212           not found
        PUSH DE                  ; 33014 213
        EX DE, HL                ; 33015 235
        LD DE, (33390)           ; 33016 237 91  110 130   DE=load length
        PUSH DE                  ; 33020 213
        CALL L33069              ; 33021 205 45  129       load a program data file
        POP DE                   ; 33024 209
        POP HL                   ; 33025 225
        PUSH HL                  ; 33026 229
        PUSH DE                  ; 33027 213
        CALL L33262              ; 33028 205 238 129       verify checksum
        LD DE, (33394)           ; 33031 237 91  114 130
        AND A                    ; 33035 167
        SBC HL, DE               ; 33036 237 82
        SCF                      ; 33038 55
        POP BC                   ; 33039 193
        POP DE                   ; 33040 209
        JR Z, L33046             ; 33041 40  3
        CCF                      ; 33043 63                checksum mis-match
        JR L33061                ; 33044 24  15

L33046: PUSH AF                  ; 33046 245
        LD HL, (33392)           ; 33047 42  112 130
        LD A, H                  ; 33050 124
        OR L                     ; 33051 181
        JR Z, L33060             ; 33052 40  6
        ADD HL, DE               ; 33054 25
        DEC HL                   ; 33055 43
        EX DE, HL                ; 33056 235
        CALL L33325              ; 33057 205 45  130       unpack data block
L33060: POP AF                   ; 33060 241
L33061: PUSH AF                  ; 33061 245
        POP BC                   ; 33062 193
        POP AF                   ; 33063 241
        LD A, C                  ; 33064 121
        RRA                      ; 33065 31
        RET PO                   ; 33066 224
        EI                       ; 33067 251
        RET                      ; 33068 201

L33069: PUSH HL                  ; 33069 229
        POP IX                   ; 33070 221 225
        LD A, 255                ; 33072 62  255      indicate "data"
        OR A                     ; 33074 183
        SCF                      ; 33075 55           indicate "load"
        EX AF, AF'               ; 33076 8
        LD A, 2                  ; 33077 62  2
        LD (33220), A            ; 33079 50  196 129
        LD A, 8                  ; 33082 62  8
        OUT (254), A             ; 33084 211 254
        LD HL, 33227             ; 33086 33  203 129  return address
        PUSH HL                  ; 33089 229
        JP 1378                  ; 33090 195 98  5    TAP loader POKEs the same values = $0562 = LD_BYTES+12

; ^
; **********

; ********** these 12 bytes differ between loader & runner
L33093: ADD A, 16                ; 33093 198 16       switch in RAM page A
        LD BC, 32765             ; 33095 1   253 127  $7ffd
L33098: OUT (C), A               ; 33098 237 121
        RET                      ; 33100 201
;        XOR (HL)                 ; 33101 174
;        ADD A, C                 ; 33102 129
; **********

;        JR NC, 33096             ; 33103 48  247     invalid jump
;        LD A, 191                ; 33105 62  191
;        CP B                     ; 33107 184
;        JR NC, 33096             ; 33108 48  242
;        INC H                    ; 33110 36
;        JR NZ, L33098            ; 33111 32  241
;L33113: LD B, 195                ; 33113 6   195
;        CALL L33202              ; 33115 205 178 129       ?
;        JR NC, 33096             ; 33118 48  232
;        LD A, B                  ; 33120 120
;        CP 212                   ; 33121 254 212
;        JR NC, L33113            ; 33123 48  244
;        CALL L33202              ; 33125 205 178 129       ?
;        RET NC                   ; 33128 208
;        LD A, 1                  ; 33129 62  1
;        LD (33220), A            ; 33131 50  196 129
;        LD H, 0                  ; 33134 38  0
;        LD B, 192                ; 33136 6   192
;        JR L33171                ; 33138 24  31

;L33140: EX AF, AF'               ; 33140 8
;        JR NZ, L33150            ; 33141 32  7
;        JR NC, L33160            ; 33143 48  15
;        LD (IX+0), L             ; 33145 221 117 0
;        JR L33165                ; 33148 24  15

;L33150: RL C                     ; 33150 203 17
;        XOR L                    ; 33152 173
;        RET NZ                   ; 33153 192
;        LD A, C                  ; 33154 121
;        RRA                      ; 33155 31
;        LD C, A                  ; 33156 79
;        INC DE                   ; 33157 19
;        JR L33167                ; 33158 24  7

;L33160: LD A, (IX+0)             ; 33160 221 126 0
;        XOR L                    ; 33163 173
;        RET NZ                   ; 33164 192
;L33165: INC IX                   ; 33165 221 35
;L33167: DEC DE                   ; 33167 27
;        EX AF, AF'               ; 33168 8
;        LD B, 194                ; 33169 6   194
;L33171: LD L, 1                  ; 33171 46  1
;L33173: CALL L33198              ; 33173 205 174 129       ?
;        RET NC                   ; 33176 208
;        LD A, 219                ; 33177 62  219
;        CP B                     ; 33179 184
;        RL L                     ; 33180 203 21
;        LD B, 192                ; 33182 6   192
;        JP NC, L33173            ; 33184 210 149 129
;        LD A, H                  ; 33187 124
;        XOR L                    ; 33188 173
;        LD H, A                  ; 33189 103
;        LD A, D                  ; 33190 122
;        OR E                     ; 33191 179
;        JR NZ, L33140            ; 33192 32  202
;        LD A, H                  ; 33194 124
;        CP 1                     ; 33195 254 1
;        RET                      ; 33197 201

;L33198: CALL L33202              ; 33198 205 178 129       ?
;        RET NC                   ; 33201 208
;L33202: AND A                    ; 33202 167
;L33203: INC B                    ; 33203 4
;        RET Z                    ; 33204 200
;        LD A, 127                ; 33205 62  127
;        IN A, (254)              ; 33207 219 254      $7ffe (SPACE, SYM SHFT, M, N, B)
;        RRA                      ; 33209 31
;        RET NC                   ; 33210 208
;        XOR C                    ; 33211 169
;        AND 32                   ; 33212 230 32
;        JR Z, L33203             ; 33214 40  243
;        LD A, C                  ; 33216 121
;        CPL                      ; 33217 47
;        LD C, A                  ; 33218 79
;        AND 2                    ; 33219 230 2        may be 1 or 2
;        OR 8                     ; 33221 246 8
;        OUT (254), A             ; 33223 211 254
;        SCF                      ; 33225 55
;        RET                      ; 33226 201

L33227: PUSH AF                  ; 33227 245          return point after loading a file
        XOR A                    ; 33228 175
        OUT (254), A             ; 33229 211 254
        POP AF                   ; 33231 241
        RET                      ; 33232 201

L33233: LD A, (DE)               ; 33233 26           search header table for matching row
        CP (HL)                  ; 33234 190
        JR NZ, L33243            ; 33235 32  6        mis-match
L33237: INC HL                   ; 33237 35
        INC DE                   ; 33238 19
        DJNZ L33233              ; 33239 16  248
L33241: SCF                      ; 33241 55
        RET                      ; 33242 201          return "match"

L33243: CP 65                    ; 33243 254 65
        JR C, L33252             ; 33245 56  5        if < "A"
        OR 32                    ; 33247 246 32       change to lower case
        CP (HL)                  ; 33249 190          compare again
        JR Z, L33237             ; 33250 40  241
L33252: CP 32                    ; 33252 254 32       compare to " "
        JR NZ, L33260            ; 33254 32  4
        LD A, (HL)               ; 33256 126
        OR A                     ; 33257 183          check for zero terminator
        JR Z, L33241             ; 33258 40  237
L33260: AND A                    ; 33260 167
        RET                      ; 33261 201          return "no match"

L33262: EXX                      ; 33262 217          verify checksum
        LD HL, 65535             ; 33263 33  255 255
        EXX                      ; 33266 217
L33267: LD A, (HL)               ; 33267 126
        EXX                      ; 33268 217
        CALL L33284               ; 33269 205 4   130  update checksum
        EXX                      ; 33272 217
        INC HL                   ; 33273 35
        DEC DE                   ; 33274 27
        LD A, D                  ; 33275 122
        OR E                     ; 33276 179
        JR NZ, L33267            ; 33277 32  244
        EXX                      ; 33279 217
        PUSH HL                  ; 33280 229
        EXX                      ; 33281 217
        POP HL                   ; 33282 225
        RET                      ; 33283 201

L33284: LD C,A : XOR H : AND $f0 :                   ;update checksum
        LD D,A : RRA : RRA : RRA :
        LD B,A : RRA : XOR H : AND $0f :
        LD E,A : LD A,L : XOR B  :
        LD H,A : LD A,E : XOR C  : AND $0f :
        LD C,A : RLA : RLA : RLA : RLA :
        LD B,A : RLCA : AND $01 :
        LD E,A : LD A,B : XOR H  :  XOR E
        LD H,A : LD A,B : RLA : XOR D : OR C
        LD L,A : RET

        ;on entry, HL = packed data load address
        ;          DE = unpacked data end address [HL + (33392) - 1]
        ;          BC = packed data length
L33325: ADD HL, BC               ; 33325 9            unpack data block
        DEC HL                   ; 33326 43
        DEC HL                   ; 33327 43
        DEC HL                   ; 33328 43
        LD A, (HL)               ; 33329 126
        EX AF, AF'               ; 33330 8            A'=3rd byte from end of data (N)             $80=($5604)
        DEC HL                   ; 33331 43
        LD A, (HL)               ; 33332 126          A =4th byte from end of data (N-1)           $82=($5603)
        DEC HL                   ; 33333 43           HL=5th byte from end of data address =N-2        ($5602)
        DEC BC                   ; 33334 11
        DEC BC                   ; 33335 11
        DEC BC                   ; 33336 11
        DEC BC                   ; 33337 11           BC=program data length - 4                   $1603
L33338: CP (HL)                  ; 33338 190          compare byte (N-1) to byte (N-2)             $82:($5602)
        JR Z, L33347             ; 33339 40  6
L33341: LDD                      ; 33341 237 168      if different, copy (HL) to (DE)
        JP PE, L33338            ; 33343 234 58  130  if BC<>0
        RET                      ; 33346 201

L33347: EX AF, AF'               ; 33347 8            if the same
        DEC HL                   ; 33348 43
        CP (HL)                  ; 33349 190          compare byte (N) to byte (N-3)               $80:($5601)
        JR Z, L33356             ; 33350 40  4
        INC HL                   ; 33352 35           if different, go back & copy previous byte
        EX AF, AF'               ; 33353 8
        JR L33341                ; 33354 24  241

L33356: PUSH AF                  ; 33356 245          if the same - $80
        PUSH BC                  ; 33357 197          $1603
        DEC HL                   ; 33358 43
        LD A, (HL)               ; 33359 126          $40=($5600)
        DEC HL                   ; 33360 43
        LD B, (HL)               ; 33361 70           $43=($55ff)
        DEC HL                   ; 33362 43           $55fe
L33363: LD (DE), A               ; 33363 18           ($5aff)=$40
        DEC DE                   ; 33364 27           $5afe
        DJNZ L33363              ; 33365 16  252      $43 - $01 = $42
        POP BC                   ; 33367 193
        DEC BC                   ; 33368 11
        DEC BC                   ; 33369 11
        DEC BC                   ; 33370 11
        DEC BC                   ; 33371 11
        LD A, B                  ; 33372 120
        OR C                     ; 33373 177
        JR Z, L33380             ; 33374 40  4
        POP AF                   ; 33376 241
        EX AF, AF'               ; 33377 8
        JR L33338                ; 33378 24  214
L33380: POP AF                   ; 33380 241
        RET                      ; 33381 201

L33382: 33382 16 bytes load area

;L33398: LD BC, 53                ; 33398 1   53  0
;        ADD HL, BC               ; 33401 9
;        LD A, 23                 ; 33402 62  23
;L33404: LD C, (HL)               ; 33404 78
;        INC HL                   ; 33405 35
;        LD B, (HL)               ; 33406 70
;        INC HL                   ; 33407 35
;        PUSH HL                  ; 33408 229
;        PUSH BC                  ; 33409 197
;        POP IX                   ; 33410 221 225
;        ADD IX, DE               ; 33412 221 25
;        LD L, (IX+1)             ; 33414 221 110 1
;        LD H, (IX+2)             ; 33417 221 102 2
;        ADD HL, DE               ; 33420 25
;L33421: LD (IX+1), L             ; 33421 221 117 1
;        LD (IX+2), H             ; 33424 221 116 2
;        POP HL                   ; 33427 225
;        DEC A                    ; 33428 61
;        JR NZ, L33404            ; 33429 32  229
;        LD A, 195                ; 33431 62  195
;        LD (DE), A               ; 33433 18
;        PUSH DE                  ; 33434 213
;        POP IX                   ; 33435 221 225
;        LD HL, 27                ; 33437 33  27  0
;        ADD HL, DE               ; 33440 25
;        EX DE, HL                ; 33441 235
;        INC HL                   ; 33442 35
;        LD (HL), E               ; 33443 115
;        INC HL                   ; 33444 35
;        LD (HL), D               ; 33445 114
;        POP HL                   ; 33446 225
;        POP DE                   ; 33447 209
;        POP BC                   ; 33448 193
;        JP (IX)                  ; 33449 221 233

Offset(h) 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F
000002A0                                   21 00 28 00 2F             !.(./
000002B0  00 33 00 41 00 44 00 4E 00 52 00 59 00 5D 00 6C  .3.A.D.N.R.Y.].l
000002C0  00 76 00 8C 00 93 00 A1 00 B0 00 BA 00 C0 00 EA  .v.......
000002D0  00 F5 00 03 01 4A 01 94 01 00 00 09 3E 2C        ....J.....>,

;L33502: LD C, (HL)               ; 33502 78
;        INC HL                   ; 33503 35
;        LD B, (HL)               ; 33504 70
;        INC HL                   ; 33505 35
;        PUSH HL                  ; 33506 229
;        PUSH BC                  ; 33507 197
;        POP IX                   ; 33508 221 225
;        ADD IX, DE               ; 33510 221 25
;        LD L, (IX+1)             ; 33512 221 110 1
;        LD H, (IX+2)             ; 33515 221 102 2
;        ADD HL, DE               ; 33518 25
;        LD (IX+1), L             ; 33519 221 117 1
;        LD (IX+2), H             ; 33522 221 116 2
;        POP HL                   ; 33525 225
;        DEC A                    ; 33526 61
;        JR NZ, L33502            ; 33527 32  229
;        LD A, 195                ; 33529 62  195
;        LD (DE), A               ; 33531 18
;        PUSH DE                  ; 33532 213
;        POP IX                   ; 33533 221 225
;        LD HL, 27                ; 33535 33  27  0
;        ADD HL, DE               ; 33538 25
;        EX DE, HL                ; 33539 235
;        INC HL                   ; 33540 35
;        LD (HL), E               ; 33541 115
;        INC HL                   ; 33542 35
;        LD (HL), D               ; 33543 114
;        POP HL                   ; 33544 225
;        POP DE                   ; 33545 209
;        POP BC                   ; 33546 193
;        LD A, B                  ; 33547 120
;        INC A                    ; 33548 60
;        JR NZ, L33555            ; 33549 32  4
;        LD A, C                  ; 33551 121
;        INC A                    ; 33552 60
;        JR Z, L33559             ; 33553 40  4
;L33555: LD (555), BC             ; 33555 237 67  43  2
;L33559: JP (IX)                  ; 33559 221 233

Offset(h) 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F

00000310                             35 00 3B 00 41 00 47           5.;.A.G
00000320  00 4D 00 54 00 73 00 7B 00 AD 00 B7 00 E3 00 EF  .M.T.s.{....
00000330  00 0C 01 33 01 4B 01 4E 01 58 01 5B 01 5E 01 63  ...3.K.N.X.[.^.c
00000340  01 66 01 69 01 6C 01 6F 01 75 01 78 01 7B 01 83  .f.i.l.o.u.x.{.
00000350  01 86 01 89 01 8C 01 94 01 99 01 9C 01 A1 01 A5  ........
00000360  01 B4 01 C9 01 D9 01 EA 01 F1 01 0B 02 2A 02 69  ........*.i
00000370  02 00                                            ..


; **********
; "c" CODE

        LD A, 32                 ; 36864 62  32       TAP loader POKEs 20 ($14)
        LD BC, 32765             ; 36866 1   253 127  $7ffd
        OUT (C), A               ; 36869 237 121      now switches in page 4
        LD A, 195                ; 36871 62  195
        LD (58028), A            ; 36873 50  172 226  58028-14592=43436 (active address $a9ac)
        NOP                      ; 36876 0
        LD A, 98                 ; 36877 62  98
        LD (58029), A            ; 36879 50  173 226
        LD A, 5                  ; 36882 62  5
        LD (58030), A            ; 36884 50  174 226  =JP 1378 ($0562) = LD_BYTES+$0c
        NOP                      ; 36887 0
        JP 23596                 ; 36888 195 44  92   to 27479 ($6b57)
        NOP                      ; 36891-36903 0

; **********

        ;on entry, HL = packed data load address
        ;          DE = unpacked data end address [HL + (33392) - 1]
        ;          BC = packed data length

00000062  00[00 40]53 43 52 45 45 00  ..@SCREE. $4000 16384+ 5639
A:SCREE   : 07 16 00 1b 83 b5 64 74   : $4000, 5639

        org  32400

        ld   HL,$4000
        ld   DE,$5aff            ; = $4000 + $1b00 -1
        ld   BC,$1607            ; = 5639

       ;org  32409

L33325: ADD HL, BC               ; 33325 9            unpack data block
        DEC HL                   ; 33326 43
        DEC HL                   ; 33327 43
        DEC HL                   ; 33328 43
        LD A, (HL)               ; 33329 126
        EX AF, AF'               ; 33330 8            A'=3rd byte from end of data (N)             $80=($5604)
        DEC HL                   ; 33331 43
        LD A, (HL)               ; 33332 126          A =4th byte from end of data (N-1)           $82=($5603)
        DEC HL                   ; 33333 43           HL=5th byte from end of data address =N-2        ($5602)
        DEC BC                   ; 33334 11
        DEC BC                   ; 33335 11
        DEC BC                   ; 33336 11
        DEC BC                   ; 33337 11           BC=program data length - 4                   $1603
L33338: CP (HL)                  ; 33338 190          compare byte (N-1) to byte (N-2)             $82:($5602)
        JR Z, L33347             ; 33339 40  6
L33341: LDD                      ; 33341 237 168      if different, copy (HL) to (DE)
        JP PE, L33338            ; 33343 234 58  130  if BC<>0
        RET                      ; 33346 201

L33347: EX AF, AF'               ; 33347 8            if the same
        DEC HL                   ; 33348 43
        CP (HL)                  ; 33349 190          compare byte (N) to byte (N-3)               $80:($5601)
        JR Z, L33356             ; 33350 40  4
        INC HL                   ; 33352 35           if different, go back & copy previous byte
        EX AF, AF'               ; 33353 8
        JR L33341                ; 33354 24  241

L33356: PUSH AF                  ; 33356 245          if the same - $80
        PUSH BC                  ; 33357 197          $1603
        DEC HL                   ; 33358 43
        LD A, (HL)               ; 33359 126          $40=($5600)
        DEC HL                   ; 33360 43
        LD B, (HL)               ; 33361 70           $43=($55ff)
        DEC HL                   ; 33362 43           $55fe
L33363: LD (DE), A               ; 33363 18           ($5aff)=$40
        DEC DE                   ; 33364 27           $5afe
        DJNZ L33363              ; 33365 16  252      $43 - $01 = $42
        POP BC                   ; 33367 193
        DEC BC                   ; 33368 11
        DEC BC                   ; 33369 11
        DEC BC                   ; 33370 11
        DEC BC                   ; 33371 11
        LD A, B                  ; 33372 120
        OR C                     ; 33373 177
        JR Z, L33380             ; 33374 40  4
        POP AF                   ; 33376 241
        EX AF, AF'               ; 33377 8
        JR L33338                ; 33378 24  214
L33380: POP AF                   ; 33380 241
        RET                      ; 33381 201

; **********