
TYPHOON : Boot sector code

        DI                       ; FE10 F3
        LD BC, $7FFD             ; FE11 01 FD 7F
        LD A, $13                ; FE14 3E 13
        OUT (C), A               ; FE16 ED 79
        LD BC, $1FFD             ; FE18 01 FD 1F
        LD A, $0C                ; FE1B 3E 0C
        OUT (C), A               ; FE1D ED 79
        XOR A                    ; FE1F AF
        OUT ($FE), A             ; FE20 D3 FE         ROM 3; RAM 5,2,3
        LD HL, $5800             ; FE22 21 00 58
        LD DE, $5801             ; FE25 11 01 58
        LD BC, $02FF             ; FE28 01 FF 02
        LD (HL), A               ; FE2B 77
        LDIR                     ; FE2C ED B0         reset attributes
        LD H, A                  ; FE2E 67
        LD L, H                  ; FE2F 6C
        LD ($5CB0), HL           ; FE30 22 B0 5C      reset NMIADD
        LD B, $02                ; FE33 06 02
        CALL L_FF07              ; FE35 CD 07 FF      pause
        CALL L_FE5A              ; FE38 CD 5A FE      load file TYa3-c200,0c00.BIN
        LD HL, L_FE49            ; FE3B 21 49 FE
        LD DE, $C000             ; FE3E 11 00 C0
        LD BC, $0011             ; FE41 01 11 00
        LDIR                     ; FE44 ED B0
        JP $C000                 ; FE46 C3 00 C0      break

L_FE49: LD SP, $F000             ; FE49 31 00 F0      copied to $c000
        LD HL, $C000             ; FE4C 21 00 C0
        LD DE, $F200             ; FE4F 11 00 F2
        LD BC, $1000             ; FE52 01 00 10
        LDIR                     ; FE55 ED B0
        JP $F220                 ; FE57 C3 20 F2

;##########

L_F200: LD SP, $F000             ; F200 31 00 F0
        LD HL, $C000             ; F203 21 00 C0
        LD DE, L_F200            ; F206 11 00 F2
        LD BC, $1000             ; F209 01 00 10
        LDIR                     ; F20C ED B0
        JP L_F220                ; F20E C3 20 F2

        PUSH HL                  ; F211-F3FF E5

        NOP                      ; F400-F604 00

        DI                       ; F605 F3
        ;some decoding palaver follows
        ;...
L_FC80: LD SP, L_FC80            ; FC80 31 80 FC
        LD A, $02                ; FC83 3E 02
        LD ($FE9D), A            ; FC85 32 9D FE
        CALL L_FD33              ; FC88 CD 33 FD
        LD HL, L_FEA9            ; FC8B 21 A9 FE
        LD D, $00                ; FC8E 16 00
        LD C, $09                ; FC90 0E 09         ;ROM 3; RAM 5,2,3
        CALL L_FDC5              ; FC92 CD C5 FD      ;load $fea9-$100a8
        LD A, $03                ; FC95 3E 03
        LD ($FE9D), A            ; FC97 32 9D FE
        CALL L_FD25              ; FC9A CD 25 FD
        LD A, $01                ; FC9D 3E 01
        LD HL, $8000             ; FC9F 21 00 80      ;ROM 3; RAM 5,2,3
        CALL L_FD69              ; FCA2 CD 69 FD      ;load $8000-$9bff
        LD HL, $8000             ; FCA5 21 00 80
        LD DE, $4000             ; FCA8 11 00 40
        LD BC, $1B00             ; FCAB 01 00 1B
        LDIR                     ; FCAE ED B0         ;copy $8000-$9aff to display
        LD A, $02                ; FCB0 3E 02
        LD HL, $5F68             ; FCB2 21 68 5F      ;ROM 3; RAM 5,2,3
        CALL L_FD69              ; FCB5 CD 69 FD      ;load $5f68-$c367
        CALL L_FD1D              ; FCB8 CD 1D FD
        LD A, $03                ; FCBB 3E 03
        LD HL, $0000             ; FCBD 21 00 00      ;RAM 0,1,2,3
        CALL L_FD69              ; FCC0 CD 69 FD      ;load $0000-$7fff
        CALL L_FD19              ; FCC3 CD 19 FD
        LD A, $04                ; FCC6 3E 04
        LD HL, $0000             ; FCC8 21 00 00      ;RAM 4,7,6,3
        CALL L_FD69              ; FCCB CD 69 FD      ;load $0000-$efff
        CALL L_FD25              ; FCCE CD 25 FD
        LD HL, $5800             ; FCD1 21 00 58
        LD DE, $5801             ; FCD4 11 01 58
        LD BC, $02FF             ; FCD7 01 FF 02
        LD (HL), L               ; FCDA 75
        LDIR                     ; FCDB ED B0         ;reset attributes
        LD A, $05                ; FCDD 3E 05         ;ROM 3; RAM 5,2,3
        LD HL, $4000             ; FCDF 21 00 40      ;load $4000-$4fff
        CALL L_FD69              ; FCE2 CD 69 FD

        LD D, $10                ; FCE5 16 10
        LD HL, $7E14             ; FCE7 21 14 7E
        EXX                      ; FCEA D9
        LD SP, $5700             ; FCEB 31 00 57
        LD HL, L_FCFC            ; FCEE 21 FC FC
        LD DE, $5F00             ; FCF1 11 00 5F
        LD BC, $001D             ; FCF4 01 1D 00
        LDIR                     ; FCF7 ED B0         ;copy next segment to $5f00
        JP $5F00                 ; FCF9 C3 00 5F

L_FCFC: LD BC, $1FFD             ; FCFC 01 FD 1F      ;copied to $5f00
        LD A, $04                ; FCFF 3E 04
        OUT (C), A               ; FD01 ED 79         ;ROM 3; RAM 5,2,3
        LD HL, $4000             ; FD03 21 00 40
        LD DE, $F000             ; FD06 11 00 F0
        LD BC, $1000             ; FD09 01 00 10
        LDIR                     ; FD0C ED B0         ;copy $4000-$4fff to $f000-$fff
        LD HL, $2758             ; FD0E 21 58 27
        EXX                      ; FD11 D9
        LD BC, $7FFD             ; FD12 01 FD 7F
        LD A, D                  ; FD15 7A            ;A =D =$10
        OUT (C), A               ; FD16 ED 79         ;ROM 3; RAM 5,2,0
        JP (HL)                  ; FD18 E9            ;JP $7e14

;##########

L_FE5A: LD DE, $FF18             ; FE5A 11 18 FF                BC= jump DE= flag HL= load
        CALL L_FE92              ; FE5D CD 92 FE      to $fe9d: BC=$fec7 DE=$ff18 HL=$ff25
        LD A, ($FF25)            ; FE60 3A 25 FF
        OR A                     ; FE63 B7
        JR NZ, L_FE5A            ; FE64 20 F4
        LD DE, $FF12             ; FE66 11 12 FF
        CALL L_FE7C              ; FE69 CD 7C FE      to $fe9d: BC=$fee5 DE=$ff12 HL=$ff25
                                 ;                    to $fe9d: BC=$fec7 DE=$ff16 HL=$ff25
        LD DE, $FF18             ; FE6C 11 18 FF
        CALL L_FE92              ; FE6F CD 92 FE      to $fe9d: BC=$fec7 DE=$ff18 HL=$ff25
        LD DE, $FF1B             ; FE72 11 1B FF
        LD HL, $C200             ; FE75 21 00 C2
        CALL L_FE9A              ; FE78 CD 9A FE      to $fe9d: BC=$febc DE=$ff1b HL=$c200
        RET                      ; FE7B C9

L_FE7C: CALL L_FE8D              ; FE7C CD 8D FE
L_FE7F: LD DE, L_FF16            ; FE7F 11 16 FF
        CALL L_FE92              ; FE82 CD 92 FE
        LD HL, $FF25             ; FE85 21 25 FF
        BIT 5, (HL)              ; FE88 CB 6E
        JR Z, L_FE7F             ; FE8A 28 F3
        RET                      ; FE8C C9

L_FE8D: LD BC, L_FEE5            ; FE8D 01 E5 FE
        JR L_FE9D                ; FE90 18 0B

L_FE92: LD BC, L_FEC7            ; FE92 01 C7 FE
        LD HL, $FF25             ; FE95 21 25 FF
        JR L_FE9D                ; FE98 18 03

L_FE9A: LD BC, L_FEBC            ; FE9A 01 BC FE
L_FE9D: LD ($FEB4), BC           ; FE9D ED 43 B4 FE   set JP address
        LD A, (DE)               ; FEA1 1A
        LD B, A                  ; FEA2 47
        INC DE                   ; FEA3 13
L_FEA4: PUSH BC                  ; FEA4 C5
        LD A, (DE)               ; FEA5 1A
        INC DE                   ; FEA6 13
        CALL L_FEEB              ; FEA7 CD EB FE
        POP BC                   ; FEAA C1
        DJNZ L_FEA4              ; FEAB 10 F7
        LD BC, $2FFD             ; FEAD 01 FD 2F
        LD DE, $2010             ; FEB0 11 10 20
        JP L_FEBC                ; FEB3 C3 BC FE      $febc -or- $fec7 -or- $fee5

L_FEB6: LD B, $3F                ; FEB6 06 3F
        INI                      ; FEB8 ED A2         ** INI read **
        LD B, $2F                ; FEBA 06 2F
L_FEBC: IN A, (C)                ; FEBC ED 78
        JP P, L_FEBC             ; FEBE F2 BC FE
        AND D                    ; FEC1 A2
        JR NZ, L_FEB6            ; FEC2 20 F2
   *    LD HL, $FF25             ; FEC4 21 25 FF      break
L_FEC7: IN A, (C)                ; FEC7 ED 78
        CP $C0                   ; FEC9 FE C0
        JR C, L_FEC7             ; FECB 38 FA
        LD B, $3F                ; FECD 06 3F
        INI                      ; FECF ED A2         ** INI read **
        LD B, $2F                ; FED1 06 2F
        LD A, $05                ; FED3 3E 05
L_FED5: DEC A                    ; FED5 3D
        JR NZ, L_FED5            ; FED6 20 FD
        IN A, (C)                ; FED8 ED 78
        AND E                    ; FEDA A3
        JR NZ, L_FEC7            ; FEDB 20 EA
        LD A, (L_FF26)           ; FEDD 3A 26 FF
   *    AND $04                  ; FEE0 E6 04         break
        RET NZ                   ; FEE2 C0
        SCF                      ; FEE3 37
        RET                      ; FEE4 C9

L_FEE5: IN A, (C)                ; FEE5 ED 78
        JP P, L_FEE5             ; FEE7 F2 E5 FE
        RET                      ; FEEA C9

L_FEEB: LD BC, $2FFD             ; FEEB 01 FD 2F
        PUSH AF                  ; FEEE F5
L_FEEF: IN A, (C)                ; FEEF ED 78
        ADD A, A                 ; FEF1 87
        JR NC, L_FEEF            ; FEF2 30 FB
        ADD A, A                 ; FEF4 87
        JR NC, L_FEF9            ; FEF5 30 02
        POP AF                   ; FEF7 F1
        RET                      ; FEF8 C9

L_FEF9: POP AF                   ; FEF9 F1
        LD B, $3F                ; FEFA 06 3F
        OUT (C), A               ; FEFC ED 79
        LD B, $2F                ; FEFE 06 2F
        LD A, $05                ; FF00 3E 05
L_FF02: DEC A                    ; FF02 3D
        NOP                      ; FF03 00
        JR NZ, L_FF02            ; FF04 20 FC
        RET                      ; FF06 C9

L_FF07: LD HL, $0000             ; FF07 21 00 00
L_FF0A: DEC HL                   ; FF0A 2B
        LD A, H                  ; FF0B 7C
        OR L                     ; FF0C B5
        JR NZ, L_FF0A            ; FF0D 20 FB
        DJNZ L_FF0A              ; FF0F 10 F9
        RET                      ; FF11 C9

;**********

L_FD19: LD A, $0F                ; FD19 3E 0F
        JR L_FD1F                ; FD1B 18 02
L_FD1D: LD A, $09                ; FD1D 3E 09
L_FD1F: LD BC, $1FFD             ; FD1F 01 FD 1F
        OUT (C), A               ; FD22 ED 79
        RET                      ; FD24 C9

L_FD25: LD A, $13                ; FD25 3E 13
        LD BC, $7FFD             ; FD27 01 FD 7F
        OUT (C), A               ; FD2A ED 79
        LD A, $0C                ; FD2C 3E 0C
        LD B, $1F                ; FD2E 06 1F
        OUT (C), A               ; FD30 ED 79
        RET                      ; FD32 C9

L_FD33: LD B, $03                ; FD33 06 03         ;checks for a legal disk
L_FD35: PUSH BC                  ; FD35 C5
        LD HL, $8000             ; FD36 21 00 80
        PUSH HL                  ; FD39 E5
        LD D, $00                ; FD3A 16 00
        LD C, $02                ; FD3C 0E 02
        CALL L_FDC5              ; FD3E CD C5 FD
        LD HL, $8500             ; FD41 21 00 85
        PUSH HL                  ; FD44 E5
        LD D, $00                ; FD45 16 00
        LD C, $02                ; FD47 0E 02
        CALL L_FDC5              ; FD49 CD C5 FD
        LD BC, $0200             ; FD4C 01 00 02
        POP HL                   ; FD4F E1
        POP DE                   ; FD50 D1
L_FD51: LD A, (DE)               ; FD51 1A
        XOR (HL)                 ; FD52 AE
        JR NZ, L_FD67            ; FD53 20 12
        INC HL                   ; FD55 23
        INC DE                   ; FD56 13
        DEC BC                   ; FD57 0B
        LD A, B                  ; FD58 78
        OR C                     ; FD59 B1
        JR NZ, L_FD51            ; FD5A 20 F5
        POP BC                   ; FD5C C1
        DJNZ L_FD35              ; FD5D 10 D6
        LD HL, L_FD67            ; FD5F 21 67 FD
L_FD62: LD (HL), $23             ; FD62 36 23
        INC HL                   ; FD64 23
        JR L_FD62                ; FD65 18 FB
L_FD67: POP BC                   ; FD67 C1
        RET                      ; FD68 C9

L_FD69: LD IX, L_FEA9            ; FD69 DD 21 A9 FE
        LD C, A                  ; FD6D 4F
L_FD6E: LD A, (IX+$00)           ; FD6E DD 7E 00
        CP C                     ; FD71 B9
        JR Z, L_FD7E             ; FD72 28 0A
        INC IX                   ; FD74 DD 23
        INC IX                   ; FD76 DD 23
        INC IX                   ; FD78 DD 23
        INC IX                   ; FD7A DD 23
        JR L_FD6E                ; FD7C 18 F0
L_FD7E: LD D, (IX+$01)           ; FD7E DD 56 01
        LD E, (IX+$02)           ; FD81 DD 5E 02
        LD B, (IX+$03)           ; FD84 DD 46 03
L_FD87: LD A, $06                ; FD87 3E 06
        SUB E                    ; FD89 93
        CP B                     ; FD8A B8
        JR C, L_FD94             ; FD8B 38 07
        LD A, E                  ; FD8D 7B
        ADD A, B                 ; FD8E 80
        DEC A                    ; FD8F 3D
        LD C, A                  ; FD90 4F
        JP L_FDB1                ; FD91 C3 B1 FD
L_FD94: LD C, $05                ; FD94 0E 05
        PUSH BC                  ; FD96 C5
        PUSH AF                  ; FD97 F5
        PUSH HL                  ; FD98 E5
        PUSH DE                  ; FD99 D5
        CALL L_FDB1              ; FD9A CD B1 FD
        POP DE                   ; FD9D D1
        POP HL                   ; FD9E E1
        POP AF                   ; FD9F F1
        POP BC                   ; FDA0 C1
        LD E, A                  ; FDA1 5F
        LD A, B                  ; FDA2 78
        SUB E                    ; FDA3 93
        LD B, A                  ; FDA4 47
        SLA E                    ; FDA5 CB 23
        SLA E                    ; FDA7 CB 23
        LD A, H                  ; FDA9 7C
        ADD A, E                 ; FDAA 83
        LD H, A                  ; FDAB 67
        LD E, $01                ; FDAC 1E 01
        INC D                    ; FDAE 14
        JR L_FD87                ; FDAF 18 D6

L_FDB1: LD A, D                  ; FDB1 7A
        LD (L_FE91), A           ; FDB2 32 91 FE
        LD (L_FE9A), A           ; FDB5 32 9A FE
        LD ($FDF2), HL           ; FDB8 22 F2 FD
        LD A, E                  ; FDBB 7B
        LD (L_FE9C), A           ; FDBC 32 9C FE
        LD A, C                  ; FDBF 79
        LD ($FE9E), A            ; FDC0 32 9E FE
        JR L_FDD6                ; FDC3 18 11
L_FDC5: LD A, D                  ; FDC5 7A
        LD (L_FE91), A           ; FDC6 32 91 FE
        LD (L_FE9A), A           ; FDC9 32 9A FE
        LD ($FDF2), HL           ; FDCC 22 F2 FD
        LD A, C                  ; FDCF 79
        LD (L_FE9C), A           ; FDD0 32 9C FE
        LD ($FE9E), A            ; FDD3 32 9E FE
L_FDD6: LD DE, $FE94             ; FDD6 11 94 FE
        CALL L_FE0E              ; FDD9 CD 0E FE
        LD A, ($FEA1)            ; FDDC 3A A1 FE
        OR A                     ; FDDF B7
        JR NZ, L_FDD6            ; FDE0 20 F4
        LD DE, L_FE8E            ; FDE2 11 8E FE
        CALL L_FDF8              ; FDE5 CD F8 FD
        LD DE, $FE94             ; FDE8 11 94 FE
        CALL L_FE0E              ; FDEB CD 0E FE
        LD DE, L_FE97            ; FDEE 11 97 FE
        LD HL, $0000             ; FDF1 21 00 00
        CALL L_FE16              ; FDF4 CD 16 FE
        RET                      ; FDF7 C9

L_FDF8: CALL L_FE09              ; FDF8 CD 09 FE
L_FDFB: LD DE, L_FE92            ; FDFB 11 92 FE
        CALL L_FE0E              ; FDFE CD 0E FE
        LD HL, $FEA1             ; FE01 21 A1 FE
        BIT 5, (HL)              ; FE04 CB 6E
        JR Z, L_FDFB             ; FE06 28 F3
        RET                      ; FE08 C9

L_FE09: LD BC, L_FE61            ; FE09 01 61 FE
        JR L_FE19                ; FE0C 18 0B
L_FE0E: LD BC, L_FE43            ; FE0E 01 43 FE
        LD HL, $FEA1             ; FE11 21 A1 FE
        JR L_FE19                ; FE14 18 03
L_FE16: LD BC, L_FE38            ; FE16 01 38 FE
L_FE19: LD ($FE30), BC           ; FE19 ED 43 30 FE
        LD A, (DE)               ; FE1D 1A
        LD B, A                  ; FE1E 47
        INC DE                   ; FE1F 13
L_FE20: PUSH BC                  ; FE20 C5
        LD A, (DE)               ; FE21 1A
        INC DE                   ; FE22 13
        CALL L_FE67              ; FE23 CD 67 FE
        POP BC                   ; FE26 C1
        DJNZ L_FE20              ; FE27 10 F7
        LD BC, $2FFD             ; FE29 01 FD 2F
        LD DE, $2010             ; FE2C 11 10 20
        JP L_FE38                ; FE2F C3 38 FE
L_FE32: LD B, $3F                ; FE32 06 3F
   *    INI                      ; FE34 ED A2         INI load
        LD B, $2F                ; FE36 06 2F
L_FE38: IN A, (C)                ; FE38 ED 78
        JP P, L_FE38             ; FE3A F2 38 FE
        AND D                    ; FE3D A2
        JR NZ, L_FE32            ; FE3E 20 F2
   *    LD HL, $FEA1             ; FE40 21 A1 FE      break
L_FE43: IN A, (C)                ; FE43 ED 78
        CP $C0                   ; FE45 FE C0
        JR C, L_FE43             ; FE47 38 FA
        LD B, $3F                ; FE49 06 3F
   *    INI                      ; FE4B ED A2         INI load
        LD B, $2F                ; FE4D 06 2F
        LD A, $05                ; FE4F 3E 05
L_FE51: DEC A                    ; FE51 3D
        JR NZ, L_FE51            ; FE52 20 FD
        IN A, (C)                ; FE54 ED 78
        AND E                    ; FE56 A3
        JR NZ, L_FE43            ; FE57 20 EA
        LD A, (L_FEA2)           ; FE59 3A A2 FE
   *    AND $04                  ; FE5C E6 04         break
        RET NZ                   ; FE5E C0
        SCF                      ; FE5F 37
        RET                      ; FE60 C9

L_FE61: IN A, (C)                ; FE61 ED 78
        JP P, L_FE61             ; FE63 F2 61 FE
        RET                      ; FE66 C9

L_FE67: LD BC, $2FFD             ; FE67 01 FD 2F
        PUSH AF                  ; FE6A F5
L_FE6B: IN A, (C)                ; FE6B ED 78
        ADD A, A                 ; FE6D 87
        JR NC, L_FE6B            ; FE6E 30 FB
        ADD A, A                 ; FE70 87
        JR NC, L_FE75            ; FE71 30 02
        POP AF                   ; FE73 F1
        RET                      ; FE74 C9

L_FE75: POP AF                   ; FE75 F1
        LD B, $3F                ; FE76 06 3F
        OUT (C), A               ; FE78 ED 79
        LD B, $2F                ; FE7A 06 2F
        LD A, $05                ; FE7C 3E 05
L_FE7E: DEC A                    ; FE7E 3D
        NOP                      ; FE7F 00
        JR NZ, L_FE7E            ; FE80 20 FC
        RET                      ; FE82 C9

        LD HL, $0000             ; FE83 21 00 00
L_FE86: DEC HL                   ; FE86 2B
        LD A, H                  ; FE87 7C
        OR L                     ; FE88 B5
        JR NZ, L_FE86            ; FE89 20 FB
        DJNZ L_FE86              ; FE8B 10 F9
        RET                      ; FE8D C9

