
;TYPHOON : CODE file loader

        org  $a5b9      ;42425 (page 2)

        ;set up DOS environment
TyphoonLoader:
        ld   SP,EndStack
        ld   a,7
        call PageIn
        push iy

        ld   de,$4601   ;use 1 DOS buffer  #$46 (page 4:$cc00-$cdff)
        ld   hl,$4700   ;use 0 RAM buffers
        call $013f      ;DOSSET1346
        jp   nc,ENDTYP
        ld   iy,FILEDATA
        ld   bc,$0000
        LD   ($5CB0),bc ;reset NMIADD

                        ;load: TYa3-c200,0c00.BIN (load directly to 3:$f400)
                        ;load: TYd3-fea9,0157.BIN
                        ;load: TYf5-5f68,2098.BIN, TYh3-c000,0368.BIN
                        ;load: TYi0-0000,4000.BIN, TYj1-4000,4000.BIN
                        ;load: TYk4-0000,0b40.BIN, TYk4-1b00,2500.BIN
                        ;load: TYl7-4000,4000.BIN (in 3 parts)
                        ;load: TYl7-4000,4000.BIN, TYm6-8000,4000.BIN, TYn3-c000,3000.BIN
                        ;load: TYo5-4000,1000.BIN (load directly to 3:$f000)
NextBlock:
        ld   a,(iy+00)
        cp   $ff
        scf
        jr   z,DUNTYP

        ld   (FILENAME),a
        call PageOut    ;switch to 48k ROM for PR-STRING
        ld   de,ATTRNAME
        ld   bc,6
        push iy
        ld   iy,$5c3a
        call $203c      ;PR-STRING
        pop  iy
        ld   a,7
        call PageIn     ;return to +3 DOS ROM
        ld   bc,$0301   ;file#=3, access=read
        ld   de,$0001   ;create=0, open=1
        ld   hl,FILENAME
        call $0106      ;DOS_OPEN
        jr   nc,ENDTYP

READIT: ld   b,3        ;file#=3
        ld   c,(iy+01)  ;page
        ld   l,(iy+02)
        ld   h,(iy+03)  ;HL=read address
        ld   e,(iy+04)
        ld   d,(iy+05)  ;DE=bytes to read
        call $0112      ;DOS_READ
        jr   nc,ENDTYP

        ld   b,3        ;file#=3
        call $0109      ;DOS_CLOSE
        jr   nc,ENDTYP
NEXTFILE:
        ld   bc,6
        add  iy,bc
        jr   NextBlock

DUNTYP: jr   nc,ENDTYP
        call BLANK
        ;copy $7904,$ce00,$0d00 ...
        ld   a,$04
        call PageIn
        ld   hl,$ce00
        ld   de,$4000
        ld   bc,$0d00
        ldir
        ;erase vacated space
        ld   hl,$ce00
        ld   (hl),0
        ld   de,$ce01
        ld   bc,$0cff
        ldir
        ;... to $7907,$db00,$0d00
        ld   a,$07
        call PageIn
        ld   hl,$4000
        ld   de,$db00
        ld   bc,$0d00
        ldir
        ;erase 128k system variables (last 256 bytes of file 'e')
        LD   HL,$5B00
        LD   DE,$5B01
        LD   BC,$00FF
        LD   (HL),L
        LDIR
        scf             ;flag OK
        ;restore BASIC environment
ENDTYP: pop  iy
        push af
        call nc,$0100   ;DOS_INITIALISE (after error)
        call PageOut
        pop  af
;-----
        jr   c,RUNTYP
        ld   b,0
        ld   c,a
        ret             ;return error

;----- Run: Firstly, copy the finishing code into the display file
;           so that the area occupied by this routine can be restored.
RUNTYP: di
        LD D, $10
        LD HL, $7E14
        EXX
        LD   SP,$5700
        LD   HL,GOTYP1
        LD   DE,$5000
        LD   BC,GOTYP2-GOTYP1
        LDIR
        JP   $5000

GOTYP1: LD BC, $1FFD    ;copied to $5f00
        LD A, $04
        OUT (C), A      ;48k ROM 3;

        ;restore areas overwritten by loader
        LD   BC,$7FFD
        LD   A,$14
        OUT  (C),A      ;48k ROM, RAM page 4 (DOS buffer)
        ld   hl,$cc00
        ld   (hl),$00
        ld   de,$cc01
        ld   bc,511
        ldir

        LD   BC,$7FFD
        LD   A,$12
        OUT  (C),A      ;48k ROM, RAM page 2 (loader code - this program)
        ld   hl,TyphoonLoader
        ld   (hl),$00
        ld   de,TyphoonLoader+1
        ld   bc,EndStack-TyphoonLoader-1
        ldir

        LD HL, $2758
        EXX
        LD BC, $7FFD
        LD A, D         ;A =D =$10
        OUT (C), A      ;ROM 3; RAM 5,2,0
        JP (HL)         ;JP $7e14
GOTYP2:

; Sub-Routines

BLANK:  LD HL, $5800
        LD DE, $5801
        LD BC, $02FF
        LD (HL), L
        LDIR            ;reset attributes
        RET

PageIn: di              ;switch to +3 DOS ROM, page A
        ld   c,a
        ld   a,($5b5c)  ;BANKM (23388)
        and  %11101000
        or   c
        ld   ($5b5c),a
        ld   bc,$7ffd   ;32765
        out  (c),a
        ei
        ret

PageOut:di              ;switch to 48k ROM, page 0
        ld   a,($5b5c)  ;BANKM (23388)
        set  4,a
        and  %11111000
        ld   ($5b5c),a
        ld   bc,$7ffd   ;32765
        out  (c),a
        ei
        ret

;-----
ATTRNAME:
        defb $16,$00,$00,$10,$02  ;AT 0,0;INK red
FILENAME:
        defb "?"        ;replaced with file letter
        defb $ff        ;end-of-name
FILEDATA:
;2001 DATA "a31", "a3","0000","c200","0c00"  (load directly to 3:$f400)
        defb "a",3
        defw $f400,$0c00
;2002 DATA "d31", "d3","0000","fea9","0157":[DATA "e21", "e5","0000","4000","1b00"]
        defb "d",3
        defw $fea9,$0157
;2003 DATA "f51", "f5","0000","5f68","2098":[DATA "g21", "g2","0000","8000","4000"]
        defb "f",5
        defw $5f68,$2098
;2004 DATA "h31", "h3","0000","c000","0368"
        defb "h",3
        defw $c000,$0368
;2005 DATA "i01", "i0","0000","c000","4000",
        defb "i",0
        defw $c000,$4000
;2006 DATA "j11", "j1","0000","c000","4000"
        defb "j",1
        defw $c000,$4000
;2007 DATA "k42", "v4","0000","c000","0b40", "w4","1b00","db00","2500"
        defb "v",4
        defw $c000,$0b40
        defb "w",4
        defw $db00,$2500
;2008 DATA "l73", "x7","0000","c000","1b00", "y4","1b00","ce00","0d00", "z7","2800","e800","1800"
        defb "x",7
        defw $c000,$1b00
        defb "y",4
        defw $ce00,$0d00
        defb "z",7
        defw $e800,$1800
;2009 DATA "m61", "m6","0000","c000","4000"
        defb "m",6
        defw $c000,$4000
;2010 DATA "n31", "n3","0000","c000","3000"
        defb "n",3
        defw $c000,$3000
;2011 DATA "o51", "o3","0000","f000","1000"  (load directly to 3:$f000)
        defb "o",3
        defw $f000,$1000
        defb $ff
EndLoader:
EndStack:    equ  $a910
;-----