database spot exclusive ;


select "fcommt" from systables where tabname = "systables" ;
create table fcommt (
	fctext               char(255)                       
,	fclink               serial                         	not null
)
in spotdbs
extent size 590
next size 50
;
lock table fcommt in exclusive mode;
load from "fcommt.u" insert into fcommt ;
create unique index fcommt_ix1 on fcommt ( fclink ) ;
update statistics for table fcommt ;
unlock table fcommt ;


select "feature" from systables where tabname = "systables" ;
create table feature (
	fetitle              char(140)                       
,	feauthr              char(4)                         
,	feseq                serial                         	not null
,	fever                char(1)                         
)
in spotdbs
extent size 2310
next size 210
;
lock table feature in exclusive mode;
load from "feature.u" insert into feature ;
create unique index feature_ix1 on feature ( feseq ) ;
create index feature_ix2 on feature ( feauthr ) ;
update statistics for table feature ;
unlock table feature ;


select "fgames" from systables where tabname = "systables" ;
create table fgames (
	fgname               char(64)                       	not null
,	fgpubl               char(4)                        	not null
,	fgtype               char(2)                        	not null
,	fglink               serial                         	not null
,	fgprorg              decimal(5,2)                   	not null
,	fgprbud              decimal(5,2)                   	not null
,	fgratng              char(4)                         
,	fgprdsk              decimal(5,2)                   	not null
,	fgcomsq              integer                        	not null
,	fppubl               char(4)                        	not null
,	fttype               char(2)                        	not null
,	fclink               integer                        	not null
,	fgpubl2              char(4)                         
,	fgpubl3              char(4)                         
,	fgproth              decimal(5,2)                   	not null
,	fgtkey               char(18)                       	not null
)
in spotdbs
extent size 1710
next size 150
;
lock table fgames in exclusive mode;
load from "fgames.u" insert into fgames ;
create unique index fgames_ix1 on fgames ( fglink ) ;
create index fgames_ix3 on fgames ( fclink ) ;
create index fgames_ix4 on fgames ( fppubl ) ;
create index fgames_ix5 on fgames ( fttype ) ;
create index fgames_ix2 on fgames ( fgtkey ) ;
update statistics for table fgames ;
unlock table fgames ;


select "fhosts" from systables where tabname = "systables" ;
create table fhosts (
	fhmag                char(2)                         
,	fhhost               char(2)                         
,	fhaddr               char(58)                        
,	fhname               char(36)                        
,	fhadmin              char(36)                        
,	fhemail              char(36)                        
)
in spotdbs
;
lock table fhosts in exclusive mode;
load from "fhosts.u" insert into fhosts ;
create index fhosts_ix1 on fhosts ( fhmag ) ;
update statistics for table fhosts ;
unlock table fhosts ;


select "fmagzne" from systables where tabname = "systables" ;
create table fmagzne (
	fmmag                char(2)                         
,	fmname               char(40)                        
)
in spotdbs
;
lock table fmagzne in exclusive mode;
load from "fmagzne.u" insert into fmagzne ;
create unique index fmagzne_ix1 on fmagzne ( fmmag ) ;
update statistics for table fmagzne ;
unlock table fmagzne ;


select "fpublr" from systables where tabname = "systables" ;
create table fpublr (
	fppubl               char(4)                         
,	fppname              char(48)                        
)
in spotdbs
extent size 190
;
lock table fpublr in exclusive mode;
load from "fpublr.u" insert into fpublr ;
create unique index fpublr_ix1 on fpublr ( fppubl ) ;
update statistics for table fpublr ;
unlock table fpublr ;


select "frefcde" from systables where tabname = "systables" ;
create table frefcde (
	ffentry              char(1)                         
,	ffname               char(12)                        
)
in spotdbs
;
lock table frefcde in exclusive mode;
load from "frefcde.u" insert into frefcde ;
create unique index frefcde_ix1 on frefcde ( ffentry ) ;
update statistics for table frefcde ;
unlock table frefcde ;


select "frefs" from systables where tabname = "systables" ;
create table frefs (
	frlink1              integer                        	not null
,	frentry              char(1)                        	not null
,	frmag                char(2)                        	not null
,	fryymm               char(4)                        	not null
,	frpage               decimal(4,1)                   	not null
,	frissue              decimal(4,2)                   	not null
,	frlink2              integer                        	not null
,	frseq                serial                         	not null
,	feseq                integer                        	not null
)
in spotdbs
extent size 6160
next size 560
;
lock table frefs in exclusive mode;
load from "frefs.u" insert into frefs ;
create index frefs_ix2 on frefs ( frmag, fryymm ) ;
create unique index frefs_ix1 on frefs ( frseq ) ;
create index frefs_ix3 on frefs ( frlink2 ) ;
create index frefs_ix4 on frefs ( feseq ) ;
update statistics for table frefs ;
unlock table frefs ;


select "ftypes" from systables where tabname = "systables" ;
create table ftypes (
	fttype               char(2)                         
,	fttname              char(24)                        
)
in spotdbs
;
lock table ftypes in exclusive mode;
load from "ftypes.u" insert into ftypes ;
create unique index ftypes_ix1 on ftypes ( fttype ) ;
update statistics for table ftypes ;
unlock table ftypes ;


select "Processing privileges" from systables where tabname = "systables" ;
revoke all on fcommt from public;
grant select on fcommt to public;
grant update on fcommt to public;
grant insert on fcommt to public;
grant delete on fcommt to public;
grant index on fcommt to public;
revoke all on feature from public;
grant select on feature to public;
grant update on feature to public;
grant insert on feature to public;
grant delete on feature to public;
grant index on feature to public;
revoke all on fgames from public;
grant select on fgames to public;
grant update on fgames to public;
grant insert on fgames to public;
grant delete on fgames to public;
grant index on fgames to public;
revoke all on fhosts from public;
grant select on fhosts to public;
grant update on fhosts to public;
grant insert on fhosts to public;
grant delete on fhosts to public;
grant index on fhosts to public;
revoke all on fmagzne from public;
grant select on fmagzne to public;
grant update on fmagzne to public;
grant insert on fmagzne to public;
grant delete on fmagzne to public;
grant index on fmagzne to public;
revoke all on fpublr from public;
grant select on fpublr to public;
grant update on fpublr to public;
grant insert on fpublr to public;
grant delete on fpublr to public;
grant index on fpublr to public;
revoke all on frefcde from public;
grant select on frefcde to public;
grant update on frefcde to public;
grant insert on frefcde to public;
grant delete on frefcde to public;
grant index on frefcde to public;
revoke all on frefs from public;
grant select on frefs to public;
grant update on frefs to public;
grant insert on frefs to public;
grant delete on frefs to public;
grant index on frefs to public;
revoke all on ftypes from public;
grant select on ftypes to public;
grant update on ftypes to public;
grant insert on ftypes to public;
grant delete on ftypes to public;
grant index on ftypes to public;
