MULTI-SCROLL
by Alan Davis
from ZX Computing June 1987

*HISOFT GENSM32 ASSEMBLER*
       ZX SPECTRUM

Copyright (C) HISOFT 1983,4
All rights reserved

Pass 1 errors: 00

        10 *C-
        20 *D+
        30 ;Routine for printing and scrolling text in any
        40 ;window, anywhere on the screen.
64800   50        ORG  64800
        60 ;Initialisation routine
64800   70 INIT   LD   A,(TOP)     ;Top of window
64803   80        LD   B,A
64804   90        LD   A,(BOT)     ;Bottom of window
64807  100        SUB  B
64808  110        INC  A
64809  120        LD   (LINES),A   ;No. of lines to be scrolled
64812  130        LD   A,(LEFT)    ;Left-hand column of window
64815  140        LD   B,A
64816  150        LD   A,(RIGHT)   ;Right-hand column of window
64819  160        SUB  B
64820  170        INC  A
64821  180        LD   (CHRS),A    ;No. of characters per line
64824  190        RET
       200 ;Main scrolling routine
       210 SCROLL
64825  220        CALL INIT
64828  230        LD   HL,TABLE    ;Start of address table
64831  240        LD   BC,(TOP)    ;Move the "pointer" to the
64835  250        LD   B,0         ;appropriate position in the table
64837  260        ADD  HL,BC       ;and store it in (POINT)
64838  270        ADD  HL,BC
64839  280        LD   (POINT),HL  ;Pointer position stored
64842  290 LOOP   LD   HL,(POINT)
64845  300        LD   E,(HL)
64846  310        INC  HL
64847  320        LD   D,(HL)
       330 ;Address of start of screen line now in DE
64848  340        PUSH HL
64849  350        LD   HL,(LEFT)
64852  360        LD   H,0
64854  370        ADD  HL,DE
64855  380        EX   DE,HL
       390 ;Address of left-hand side of window now in DE
64856  400        POP  HL
64857  410        LD   A,(LINES)   ;Decrease the line count
64860  420        DEC  A
64861  430        CP   0           ;Have we scrolled all the lines yet?
64863  440        JP   Z,BLANK     ;Quit this loop if we have
64866  450        LD   (LINES),A   ;Store the line count
64869  460        INC  HL          ;Move the pointer to the next item
64870  470        LD   (POINT),HL  ;in the table. Save position
64873  480        LD   C,(HL)
64874  490        INC  HL
64875  500        LD   B,(HL)      ;Start of next line down in BC
64876  510        LD   HL,(LEFT)
64879  520        LD   H,0
64881  530        ADD  HL,BC
       540 ;HL now points to the screen address 8 pixels below
       550 ;the one held in DE
64882  560        LD   B,8         ;8 pixel lines to be transferred
       570 ;Now move 8 pixel lines up the screen by 8 pixels
64884  580 TRANS  PUSH BC
64885  590        LD   BC,(CHRS)
64889  600        LD   B,0
64891  610        PUSH HL
64892  620        PUSH DE          ;Save all registers
64893  630        LDIR             ;Transfer the line of pixels
64895  640        POP  HL
64896  650        POP  DE
64897  660        LD   BC,256
64900  670        ADD  HL,BC
64901  680        EX   DE,HL
64902  690        ADD  HL,BC       ;Move HL and DE down one pixel
64903  700        POP  BC
64904  710        DJNZ TRANS
       720 ;One line of characters has now been transferred
64906  730        JP   LOOP        ;Back for next line of characters
       740 ;Scrolling finished. Now erase last character line
64909  750 BLANK  LD   B,8
64911  760 LOOP2  PUSH BC
64912  770        PUSH DE
64913  780        LD   A,(CHRS)
64916  790        LD   B,A
64917  800        XOR  A
64918  810 LOOP3  LD   (DE),A
64919  820        INC  DE
64920  830        DJNZ LOOP3
64922  840        POP  DE
64923  850        LD   BC,256
64926  860        EX   DE,HL
64927  870        ADD  HL,BC
64928  880        EX   DE,HL
64929  890        POP  BC
64930  900        DJNZ LOOP2
64932  910        RET
       920 ;Routine to set attributes in the window
       930 ATTR
64933  940        CALL INIT
64936  950        LD   A,(PAPER)
64939  960        RLCA
64940  970        RLCA
64941  980        RLCA
64942  990        LD   B,A
64943 1000        LD   A,(INK)
64946 1010        ADD  A,B
64947 1020        LD   (COLOUR),A
64950 1030        LD   HL,22528    ;Start of attributes area
64953 1040        LD   DE,32
64956 1050        LD   A,(TOP)
64959 1060        LD   B,A
64960 1070 LOOP4  XOR  A
64961 1080        CP   B
64962 1090        JP   Z,CONT
64965 1100        DEC  B
64966 1110        ADD  HL,DE
64967 1120        JP   LOOP4
      1130 ;HL points to attributes of top line of window
64970 1140 CONT   LD   DE,(LEFT)
64974 1150        LD   D,0
64976 1160        ADD  HL,DE
64977 1170        LD   (POINT),HL
      1180 ;HL points to attributes of top left of window
64980 1190        LD   A,(LINES)
64983 1200        LD   B,A
64984 1210 LOOP5  PUSH BC
64985 1220        LD   A,(CHRS)
64988 1230        LD   B,A
64989 1240        LD   A,(COLOUR)
64992 1250 LOOP6  LD   (HL),A      ;Colour the character square
64993 1260        INC  HL
64994 1270        DJNZ LOOP6       ;Back to colour the next square
      1280 ;Top line now coloured in
64996 1290        LD   HL,(POINT)
64999 1300        LD   DE,32
65002 1310        ADD  HL,DE
65003 1320        LD   (POINT),HL
65006 1330        POP  BC
65007 1340        DJNZ LOOP5       ;Back to colour the next line
65009 1350        RET
      1360 ;Routine to clear the window using repeated scrolls
      1370 CLEAR
65010 1380        CALL INIT
65013 1390        LD   A,(LINES)
65016 1400        LD   B,A
65017 1410 LOOP7  PUSH BC
65018 1420        CALL SCROLL
65021 1430        POP  BC
65022 1440        DJNZ LOOP7
65024 1450        RET
      1460 ;The first 6 of these addresses are poked from BASIC
65025 1470 TOP    DEFB 0           ;Top character line of window
65026 1480 BOT    DEFB 21          ;Bottom character line of window
65027 1490 LEFT   DEFB 0           ;Left-hand column of window
65028 1500 RIGHT  DEFB 31          ;Right-hand column of window
65029 1510 INK    DEFB 0           ;Window INK colour (0-7)
65030 1520 PAPER  DEFB 7           ;Window PAPER colour (0-7)
65031 1530 POINT  DEFW 0
65033 1540 CHRS   DEFB 0
65034 1550 LINES  DEFB 0
65035 1560 COLOUR DEFB 0
      1570 ;The table contains the screen addresses for
      1580 ;the top left-hand byte of each line of characters
65036 1590 TABLE  DEFW 16384
65038 1600        DEFW 16416
65040 1610        DEFW 16448
65042 1620        DEFW 16480
65044 1630        DEFW 16512
65046 1640        DEFW 16544
65048 1650        DEFW 16576
65050 1660        DEFW 16608
65052 1670        DEFW 18432
65054 1680        DEFW 18464
65056 1690        DEFW 18496
65058 1700        DEFW 18528
65060 1710        DEFW 18560
65062 1720        DEFW 18592
65064 1730        DEFW 18624
65066 1740        DEFW 18656
65068 1750        DEFW 20480
65070 1760        DEFW 20512
65072 1770        DEFW 20544
65074 1780        DEFW 20576
65076 1790        DEFW 20608
65078 1800        DEFW 20640
65080 1810        DEFW 20672
65082 1820        DEFW 20704
      1830 ;Routine to word-wrap z$ within defined window
      1840 WRAP
65084 1850        CALL INIT
      1860 ;Begin by looking for z$ in variables area
65087 1870        LD   HL,(VARS)   ;Start of BASIC variables
65090 1880 NEXT   LD   A,(HL)
65091 1890        CP   90          ;z$ identified by code 90
65093 1900        JP   Z,FOUND     ;Eureka!!
65096 1910        CALL SKIP        ;Find next BASIC variable (ROM)
65099 1920        EX   DE,HL
65100 1930        JP   NEXT        ;No luck yet. Try next variable
      1940 ;z$ has now been located in the variables area
65103 1950 FOUND  INC  HL
65104 1960        LD   A,(HL)
65105 1970        LD   (LEN),A     ;Store LEN z$ (up to 255 only)
65108 1980        INC  HL
65109 1990        INC  HL
65110 2000        LD   (START),HL  ;Address of start of text
65113 2010 SCAN   CALL CHECK       ;How long is the string?
65116 2020        CP   1
65118 2030        JP   Z,PRINT     ;Print it if short enough to fit
65121 2040        CALL CHOP        ;z$ too long. Prune it
65124 2050        CALL PRINT       ;Print the pruned portion
65127 2060        LD   HL,(START)
65130 2070        LD   DE,(STEP)   ;No. of chars just printed
65134 2080        LD   D,0
65136 2090        ADD  HL,DE
65137 2100        LD   (START),HL  ;Start of remaining text
65140 2110        LD   A,(STEP)
65143 2120        LD   B,A
65144 2130        LD   A,(LEN)
65147 2140        SUB  B
65148 2150        LD   (LEN),A     ;Length of text remaining
65151 2160 REPEAT LD   HL,(START)
65154 2170        LD   A,(HL)      ;Check next character
65155 2180        CP   32          ;Is it a space?
65157 2190        JP   NZ,SCAN     ;If not, process remaining text
65160 2200        INC  HL
65161 2210        LD   (START),HL
65164 2220        LD   A,(LEN)
65167 2230        DEC  A
65168 2240        LD   (LEN),A      ;Any leading space is removed
65171 2250        JP   REPEAT       ;Let's see if there are any more
      2260 ;Check length of remaining text
65174 2270 CHECK  LD   A,(CHRS)
65177 2280        ADD  A,1
65179 2290        LD   B,A
65180 2300        LD   A,(LEN)
65183 2310        CP   B            ;Does remaining text fit window?
65184 2320        JP   C,SHORT      ;Yes!
65187 2330        XOR  A            ;No!
65188 2340        RET               ;Return with zero in A
65189 2350 SHORT  LD   A,(LEN)      ;Remaining text not too long
65192 2360        LD   (STEP),A
65195 2370        LD   A,1
65197 2380        RET               ;Return with 1 in A
      2390 ;Prune the remaining text to fit the window
65198 2400 CHOP   LD   HL,(START)   ;Start of text
65201 2410        LD   A,(CHRS)     ;Width of window
65204 2420        LD   E,A
65205 2430        LD   D,0
65207 2440        ADD  HL,DE
      2450 ;HL points to the character at start of next line
65208 2460 CHLOOP LD   A,(HL)      ;Pick up the character
65209 2470        CP   32          ;Is it a space?
65211 2480        JP   NZ,DECR     ;If it isn't, a word is broken
65214 2490        LD   A,E         ;If it is, we can print this length
65215 2500        LD   (STEP),A    ;So store length to be printed
65218 2510        RET
65219 2520 DECR   DEC  DE          ;Back off by one character
65220 2530        DEC  HL
65221 2540        JP   CHLOOP      ;and try again
      2550 ;Routine to print a line of text
65224 2560 PRINT  CALL SCROLL      ;Scroll previous text
65227 2570        LD   A,(MASK_P)
65230 2580        PUSH AF          ;Save old value of MASK_P
65231 2590        LD   A,63
65233 2600        LD   (MASK_P),A  ;Effectively PAPER 8: INK 8
65236 2610        LD   A,2
65238 2620        CALL #1601       ;Use the screen
65241 2630        LD   A,22
65243 2640        RST  16          ;Effectively "PRINT AT;"
65244 2650        LD   A,(BOT)
65247 2660        RST  16
65248 2670        LD   A,(LEFT)
65251 2680        RST  16          ;Bottom left corner of window
65252 2690        LD   DE,(START)  ;Address of start of text
65256 2700        LD   BC,(STEP)   ;Length of text
65260 2710        LD   B,0
65262 2720        CALL #203C       ;Print the text (ROM)
65265 2730        POP  AF
65266 2740        LD   (MASK_P),A  ;Restore old value of MASK_P
65269 2750        RET
 6584 2760 SKIP   EQU  #19B8       ;ROM routine - find next variable
23627 2770 VARS   EQU  23627       ;Stores start of variables
65270 2780 LEN    DEFB 0
65271 2790 STEP   DEFB 0
65272 2800 START  DEFW 0
23694 2810 MASK_P EQU  23694       ;System variable for transparency

Pass 2 errors: 00
