// JMap - written by Mark Ogden - A utility to help produce HTML image
// maps. As far as I know it works quite well. If you modify it or have
// any suggestions for modifications please e-mail me at:
// root@poggy.globalnet.co.uk
// Copyright (C)1999 Mark Ogden

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import java.awt.*;
import java.io.*;

public class JMap extends Frame
{

	// First need some global variables
	imgFrame imgF;
	Frame miscFrame;
	MenuBar mainMenu;
	Menu fileMenu;
	Menu areaMenu;
	File mapFile;
	FileOutputStream fout;
	BufferedOutputStream bout;
	PrintStream pout;
	File imgFile;
	Image img;
	FileDialog fDialog;
	String mapName; 
	StringBuffer mapBuffer;
	TextArea mainArea;
	Label coords;
	int i;

	JMap()
	{
		// Create the frames - one for the main bit and one for
		// the image.
		super("JMap Image Map Creator");

		// Create the menu bar for the main frame.
		mainMenu = new MenuBar();

		// Create the String objects for passing to other classes
		mapName = new String();
		mapBuffer = new StringBuffer();

		// Add the file menu with it's items.
		fileMenu = new Menu("File");
		fileMenu.add(new MenuItem("New Map"));
		fileMenu.add(new MenuItem("Load Image"));
		fileMenu.add(new MenuItem("Save Map"));
		fileMenu.add(new MenuItem("View Map"));
		fileMenu.add(new MenuItem("Quit"));
		mainMenu.add(fileMenu);

		// Now add the area menu with it's items.
		areaMenu = new Menu("Area");
		areaMenu.add(new MenuItem("Rectangle"));
		areaMenu.add(new MenuItem("Polygon"));
		areaMenu.add(new MenuItem("Circle"));
		
		// Disable all menus except New Map and Quit
		for (i = 1; i < fileMenu.countItems() - 1; i++)
		{
			fileMenu.getItem(i).disable();
		}
		for (i = 0; i < 3; i++)
		{
			areaMenu.getItem(i).disable();
		}
		mainMenu.add(areaMenu);

		mainArea = new TextArea(30, 10);
		mainArea.setEditable(false);
		add(mainArea);

		coords = new Label("", Label.LEFT);
		add(coords, "South");

		setMenuBar(mainMenu);
		resize(400,220);
		show();
	}

	public boolean action(Event evt, Object o)
	{
		// First handle the Quit option because it's the easiest!
		if (o.toString() == "Quit")
		{
			System.exit(0);
		}
		if (o.toString() == "New Map")
		{
			new newMapFrame(mainArea, mapName, mapBuffer);
			fileMenu.getItem(0).disable();
			fileMenu.getItem(1).enable();
		}
		if (o.toString() == "View Map")
		{
			System.out.println(mapName.toString());
			System.out.println(mapBuffer.toString());
		}
		if (o.toString() == "Load Image")
		{
			fDialog = new FileDialog(this, "Open Image", fDialog.LOAD);
			fDialog.show();
			imgFile = new File(fDialog.getDirectory(), fDialog.getFile());
			img = getToolkit().getImage(imgFile.getAbsolutePath());
			mainArea.appendText("Loaded Image: " + fDialog.getFile() + "\n");
			imgF = new imgFrame(img, fDialog.getFile(), coords, mainArea, mapBuffer, fileMenu, areaMenu);
			for (i = 0; i < 3; i++)
			{
				areaMenu.getItem(i).enable();
			}
			fileMenu.getItem(2).enable();
			fileMenu.getItem(3).enable();
			fileMenu.getItem(1).disable();
		}
		if (o.toString() == "Save Map")
		{
			fDialog = new FileDialog(this, "Save Map", fDialog.SAVE);
			fDialog.show();
			mapFile = new File(fDialog.getDirectory(), fDialog.getFile());
			mapBuffer.append("</MAP>\n");
			try
			{
				fout = new FileOutputStream(mapFile);
				bout = new BufferedOutputStream(fout);
				pout = new PrintStream(bout);
				pout.print(mapBuffer.toString());
				pout.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		if (o.toString() == "Rectangle")
		{
			mainArea.appendText("Draw box starting from top left\n");
			imgF.doRect(true);
		}
		if (o.toString() == "Circle")
		{
			mainArea.appendText("Draw circle starting from top left\n");
			imgF.doCircle(true);
		}
		if (o.toString() == "Polygon")
		{
			mainArea.appendText("Click on each point and click RMB when done\n");
			imgF.doPoly(true);
		}
		return true;
	}

	public static void main(String[] args)
	{
		new JMap();
	}
}

class newMapFrame extends Frame
{

	private TextField fileField;
	private TextArea tArea;
	private String mName;
	private StringBuffer mBuffer;

	newMapFrame(TextArea ta, String mn, StringBuffer mb)
	{
		super("New Map");
		Panel p1 = new Panel();
		Panel p2 = new Panel();

		tArea = ta;
		mName = mn;
		mBuffer = mb;

		p1.setLayout(new BorderLayout());
		p2.setLayout(new BorderLayout());
		setLayout(new BorderLayout());
		fileField = new TextField(18);
		Button okButton = new Button("OK");
		Button cancelButton = new Button("Cancel");
		p1.add(new Label("Enter Map Name:"), "West");
		p1.add(fileField, "East");
		p2.add(okButton, "West");
		p2.add(cancelButton, "East");

		add(p1, "North");
		add(p2, "South");

		resize(300,100);
		show();
	}

	public boolean action(Event evt, Object o)
	{
		Object oTarget = evt.target;

		if (oTarget instanceof Button)
		{
			Button buttonTarget = (Button)oTarget;
			String sButtonString = buttonTarget.getLabel();

			if (sButtonString.compareTo("OK") == 0)
			{
				mName = fileField.getText();
				if (mName != null)
				{
					tArea.appendText("Editing " + mName + "\n");
					mBuffer.append("<MAP NAME='" + mName + "'>\n");
					dispose();
				}
			}
			else if (sButtonString.compareTo("Cancel") == 0)
			{
				dispose();
			}
		}
		return true;
	}
}

class imgFrame extends Frame
{
	Image imgMap;
	Label coords;
	Point startPoint;
	Point endPoint;
	Dimension circDim;
	TextArea mainArea;
	StringBuffer mapBuffer;
	boolean dragging;
	boolean rect;
	boolean circle;
	boolean poly;
	Polygon polyPoints;
	int i;
	Menu fileMen;
	Menu areaMen;

	imgFrame(Image img, String str, Label lb, TextArea ta, StringBuffer sb, Menu fmen, Menu amen)
	{
		super(str);

		imgMap = img;
		coords = lb;
		mainArea = ta;
		mapBuffer = sb;
		fileMen = fmen;
		areaMen = amen;

		show();
		paint(this.getGraphics());
	}

	public void doRect(boolean i)
	{
		rect = i;
	}

	public void doCircle(boolean i)
	{
		circle = i;
	}

	public void doPoly(boolean i)
	{
		poly = i;
		polyPoints = new Polygon();
	}

	public void paint(Graphics g)
	{
		g.drawImage(imgMap, 10, 30, this);
		resize(imgMap.getWidth(this) + 20, imgMap.getHeight(this) + 40);
		if (dragging)
		{
			if (rect)
			{
				g.drawRect(startPoint.x, startPoint.y, endPoint.x - startPoint.x, endPoint.y - startPoint.y);
			}
			if (circle)
			{
				g.drawOval(startPoint.x, startPoint.y, circDim.width, circDim.width);
			}
		}
		if (poly)
		{
			g.drawPolygon(polyPoints);
		}
	}

	public boolean mouseMove(Event evt, int x, int y)
	{
		if (x < 10) { x = 10; }
		if (y < 30) { y = 30; }
		coords.setText(Integer.toString(x - 10) + ", " + Integer.toString(y - 30));
		return true;
	}

	public boolean mouseDown(Event evt, int x, int y)
	{
		if (poly)
		{
			if (evt.modifiers == Event.META_MASK)
			{
				mainArea.appendText("Polygon Drawn\n");
				mapBuffer.append("<AREA SHAPE='POLY' COORDS='");
				for (i = 0; i < ((polyPoints.npoints) - 1); i++)
				{
					mapBuffer.append(Integer.toString(polyPoints.xpoints[i]) + "," + Integer.toString(polyPoints.ypoints[i]) + ",");
				}
				mapBuffer.append(Integer.toString(polyPoints.xpoints[polyPoints.npoints - 1]) + "," + Integer.toString(polyPoints.ypoints[polyPoints.npoints - 1]) + "' HREF='");
				new hrefFrame(mapBuffer);
				doPoly(false);
				paint(this.getGraphics());
			}
			else
			{
				polyPoints.addPoint(x, y);
				paint(this.getGraphics());
			}
		}
		else if (!dragging)
		{
			startPoint = new Point(x, y);
			dragging = true;
		}
		return true;
	}

	public boolean mouseDrag(Event evt, int x, int y)
	{
		if (rect)
		{
			endPoint = new Point(x, y);
			paint(this.getGraphics());
		}
		if (circle)
		{
			circDim = new Dimension(x - startPoint.x, x - startPoint.x);
			paint(this.getGraphics());
		}
		return true;
	}

	public boolean mouseUp(Event evt, int x, int y)
	{
		dragging = false;
		paint(this.getGraphics());
		if (rect)
		{
			mainArea.appendText("Start: " + Integer.toString(startPoint.x - 10) + ", " + Integer.toString(startPoint.y - 30) + "    End: " + Integer.toString(endPoint.x - 10) + ", " + Integer.toString(endPoint.y - 30) + "\n");
			mapBuffer.append("<AREA SHAPE='RECT' COORDS='" + Integer.toString(startPoint.x - 10) + "," + Integer.toString(startPoint.y - 30) + "," + Integer.toString(endPoint.x - 10) + "," + Integer.toString(endPoint.y - 30) + "' HREF='");
			new hrefFrame(mapBuffer);
			doRect(false);
		}
		if (circle)
		{
			mainArea.appendText("Center: " + Integer.toString(startPoint.x + (circDim.width / 2) - 10) + ", " + Integer.toString(startPoint.y + (circDim.height / 2) - 30) + "    Radius: " + Integer.toString(circDim.width / 2) + "\n");
			mapBuffer.append("<AREA SHAPE='CIRCLE' COORDS='" + Integer.toString(startPoint.x + (circDim.width / 2) - 10) + "," + Integer.toString(startPoint.y + (circDim.width / 2) - 30) + "," + Integer.toString(circDim.width / 2) + "' HREF='");
			new hrefFrame(mapBuffer);
			doCircle(false);
		}
		return true;
	}

	public boolean handleEvent(Event evt)
	{
		if (evt.id == Event.WINDOW_DESTROY)
		{
			if (evt.target == this)
			{
				genFrame ask = new genFrame("Everything will be lost", this);
			}
			else if (evt.target.toString() == "genFrame")
			{
				mapBuffer.setLength(0);
				fileMen.getItem(0).enable();
				for (int i = 2; i < fileMen.countItems() - 1; i++)
					fileMen.getItem(i).disable();
				for (i = 0; i < areaMen.countItems(); i++)
					areaMen.getItem(i).disable();
				mainArea.append("Map Deleted\n");
				dispose();
			}
		}
		return super.handleEvent(evt);
	}
}

class hrefFrame extends Frame
{
	TextField linkField;
	Button okButton;
	StringBuffer mapBuffer;

	hrefFrame(StringBuffer sb)
	{
		super("New Link");

		mapBuffer = sb;

		Panel p1 = new Panel();

		Label prompt = new Label("Enter Link:");
		linkField = new TextField(30);
		okButton = new Button("OK");

		p1.add(prompt, "West");
		p1.add(linkField, "East");
		add(p1, "North");
		add(okButton, "South");

		resize(400, 100);
		show();
	}

	public boolean action(Event evt, Object o)
	{
		Object oTarget = evt.target;

		if (oTarget instanceof Button)
		{
			Button buttonTarget = (Button)oTarget;
			String sButtonString = buttonTarget.getLabel();

			if (sButtonString.compareTo("OK") == 0)
			{
				String lName = linkField.getText();
				mapBuffer.append(lName + "'>\n");
				dispose();
			}
		}
		return true;
	}
}

class genFrame extends Frame
{
	Frame prnt;

	genFrame(String msg, Frame pnt)
	{
		super("Hmmm...");

		prnt = pnt;

		add(new Label("Are You Sure?"), "North");
		add(new Label(msg), "Center");
		Panel p1 = new Panel();
		p1.add(new Button("OK"), "West");
		p1.add(new Button("Cancel"), "East");
		add(p1, "South");

		resize(150,100);
		show();
	}

	public String toString()
	{
		return "genFrame";
	}

	public boolean action(Event evt, Object o)
	{
		Object oTarget = evt.target;

		if (oTarget instanceof Button)
		{
			Button bTarget = (Button)oTarget;
			String bString = bTarget.getLabel();

			if (bString.compareTo("OK") == 0)
			{
				prnt.handleEvent(new Event(this, Event.WINDOW_DESTROY, null));
				dispose();
			}
			else if (bString.compareTo("Cancel") == 0)
			{
				dispose();
			}
		}
		return true;
	}
}
